/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankstatement.file;

import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementService;
import com.axelor.exception.AxelorException;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;

public abstract class BankStatementFileService {
    protected BankStatement bankStatement;
    protected File file;
    protected String bankStatementFileFormat;
    protected final BankStatementService bankStatementService;

    @Inject
    public BankStatementFileService(BankStatementService bankStatementService) {
        this.bankStatementService = bankStatementService;
    }

    public void setBankStatement(BankStatement bankStatement) {
        this.bankStatement = bankStatement;
        this.file = this.getFile(bankStatement);
        this.bankStatementFileFormat = bankStatement.getBankStatementFileFormat().getStatementFileFormatSelect();
    }

    protected File getFile(BankStatement bankStatement) {
        return MetaFiles.getPath((MetaFile)bankStatement.getBankStatementFile()).toFile();
    }

    public void process(BankStatement bankStatement) throws IOException, AxelorException {
        this.setBankStatement(bankStatement);
        this.process();
    }

    public void process() throws IOException, AxelorException {
        if (this.bankStatement == null) {
            throw new IllegalStateException("Bank statement is not set.");
        }
    }

    protected BankStatement findBankStatement() {
        this.bankStatement = this.bankStatementService.find(this.bankStatement);
        return this.bankStatement;
    }
}

