/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.service.batch.AccountingBatchService;
import com.axelor.apps.bankpayment.service.app.AppBankPaymentService;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebit;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebitCustomerInvoice;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebitMonthlyPaymentSchedule;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebitPaymentSchedule;
import com.axelor.apps.base.db.Batch;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;

public class AccountingBatchBankPaymentService
extends AccountingBatchService {
    public Batch run(Model batchModel) throws AxelorException {
        Batch batch;
        AccountingBatch accountingBatch = (AccountingBatch)((Object)batchModel);
        if (!((AppBankPaymentService)Beans.get(AppBankPaymentService.class)).isApp("bank-payment")) {
            return super.run((Model)((Object)accountingBatch));
        }
        switch (accountingBatch.getActionSelect()) {
            case 12: {
                batch = this.directDebit(accountingBatch);
                break;
            }
            default: {
                batch = super.run((Model)((Object)accountingBatch));
            }
        }
        return batch;
    }

    public Batch directDebit(AccountingBatch accountingBatch) {
        Class batchClass;
        switch (accountingBatch.getDirectDebitDataTypeSelect()) {
            case 1: {
                batchClass = BatchDirectDebitCustomerInvoice.class;
                break;
            }
            case 2: {
                batchClass = BatchDirectDebitPaymentSchedule.class;
                break;
            }
            case 3: {
                batchClass = BatchDirectDebitMonthlyPaymentSchedule.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direct debit data type");
            }
        }
        return ((BatchDirectDebit)((Object)Beans.get(batchClass))).run(accountingBatch);
    }
}

