/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentValidateService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.bankpayment.service.batch.BatchBankPaymentService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BatchRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class BatchBankPaymentServiceImpl
implements BatchBankPaymentService {
    protected AppBaseService appBaseService;
    protected MoveService moveService;
    protected InvoicePaymentValidateService invoicePaymentValidateService;
    protected PaymentScheduleService paymentScheduleService;
    protected BankOrderCreateService bankOrderCreateService;
    protected BankOrderService bankOrderService;
    protected BankOrderLineService bankOrderLineService;
    protected BankOrderMergeService bankOrderMergeService;
    protected ReconcileRepository reconcileRepo;
    protected InvoicePaymentRepository invoicePaymentRepo;
    protected BankOrderRepository bankOrderRepo;
    protected BatchRepository batchRepo;

    @Inject
    public BatchBankPaymentServiceImpl(AppBaseService appBaseService, MoveService moveService, InvoicePaymentValidateService invoicePaymentValidateService, PaymentScheduleService paymentScheduleService, BankOrderCreateService bankOrderCreateService, BankOrderService bankOrderService, BankOrderLineService bankOrderLineService, BankOrderMergeService bankOrderMergeService, ReconcileRepository reconcileRepo, InvoicePaymentRepository invoicePaymentRepo, BankOrderRepository bankOrderRepo, BatchRepository batchRepo) {
        this.appBaseService = appBaseService;
        this.moveService = moveService;
        this.invoicePaymentValidateService = invoicePaymentValidateService;
        this.paymentScheduleService = paymentScheduleService;
        this.bankOrderCreateService = bankOrderCreateService;
        this.bankOrderService = bankOrderService;
        this.bankOrderLineService = bankOrderLineService;
        this.bankOrderMergeService = bankOrderMergeService;
        this.reconcileRepo = reconcileRepo;
        this.invoicePaymentRepo = invoicePaymentRepo;
        this.bankOrderRepo = bankOrderRepo;
        this.batchRepo = batchRepo;
    }

    @Override
    public boolean paymentScheduleLineDoneListExists(Batch batch) {
        return this.getPaymentScheduleLineDoneListQuery(batch).fetchOne() != null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder createBankOrder(Batch batch) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        PaymentScheduleLine paymentScheduleLine = (PaymentScheduleLine)this.getPaymentScheduleLineDoneListQuery(batch).fetchOne();
        if (paymentScheduleLine == null) {
            throw new AxelorException((Model)((Object)batch), 4, I18n.get((String)"No processed payment schedule lines"));
        }
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        switch (paymentSchedule.getTypeSelect()) {
            case 1: {
                return this.createBankOrderFromPaymentScheduleLines(batch);
            }
            case 2: {
                return this.createBankOrderFromMonthlyPaymentScheduleLines(batch);
            }
        }
        throw new AxelorException((Model)paymentSchedule, 4, I18n.get((String)"Unknown direct debit data type"));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder createBankOrderFromPaymentScheduleLines(Batch batch) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        List<BankOrder> bankOrderList;
        List<PaymentScheduleLine> paymentScheduleLineList;
        int offset = 0;
        while (!(paymentScheduleLineList = this.fetchPaymentScheduleLineDoneList(batch, offset)).isEmpty()) {
            this.createBankOrders(batch, paymentScheduleLineList);
            offset += paymentScheduleLineList.size();
            JPA.clear();
            batch = (Batch)((Object)this.batchRepo.find(batch.getId()));
        }
        while ((bankOrderList = this.fetchLimitedBankOrderList(batch)).size() > 1) {
            this.bankOrderMergeService.mergeBankOrders(bankOrderList);
            JPA.clear();
            batch = (Batch)((Object)this.batchRepo.find(batch.getId()));
        }
        if (bankOrderList.isEmpty()) {
            throw new AxelorException((Model)((Object)batch), 5, I18n.get((String)"No bank orders found"));
        }
        BankOrder bankOrder = (BankOrder)((Object)this.bankOrderRepo.find(bankOrderList.iterator().next().getId()));
        batch.setBankOrder(bankOrder);
        return bankOrder;
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createBankOrders(Batch batch, Collection<PaymentScheduleLine> paymentScheduleLines) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLines) {
            PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
            MoveLine creditMoveLine = paymentScheduleLine.getAdvanceMoveLine();
            for (Invoice invoice : paymentSchedule.getInvoiceSet()) {
                MoveLine debitMoveLine = this.moveService.getMoveLineService().getDebitCustomerMoveLine(invoice);
                Reconcile reconcile = this.reconcileRepo.findByMoveLines(debitMoveLine, creditMoveLine);
                if (reconcile == null) continue;
                this.createBankOrders(batch, reconcile);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createBankOrders(Batch batch, Reconcile reconcile) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        for (InvoicePayment invoicePayment : this.invoicePaymentRepo.findByReconcile(reconcile).fetch()) {
            if (invoicePayment.getBankOrder() != null) continue;
            this.invoicePaymentValidateService.validate(invoicePayment, true);
            if (invoicePayment.getBankOrder() == null) {
                throw new AxelorException((Model)((Object)invoicePayment), 5, I18n.get((String)"Failed to create bank order from invoice payment"));
            }
            invoicePayment.getBankOrder().setBatch(batch);
            this.bankOrderRepo.save((Model)((Object)invoicePayment.getBankOrder()));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BankOrder createBankOrderFromMonthlyPaymentScheduleLines(Batch batch) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        AccountingBatch accountingBatch = batch.getAccountingBatch();
        LocalDate bankOrderDate = accountingBatch.getDueDate();
        Company senderCompany = accountingBatch.getCompany();
        BankDetails senderBankDetails = accountingBatch.getBankDetails();
        if (senderBankDetails == null) {
            senderBankDetails = accountingBatch.getCompany().getDefaultBankDetails();
        }
        PaymentMode paymentMode = accountingBatch.getPaymentMode();
        Currency currency = senderCompany.getCurrency();
        int partnerType = 3;
        String senderReference = "";
        String senderLabel = "";
        if (bankOrderDate == null) {
            bankOrderDate = this.appBaseService.getTodayDate(senderCompany);
        }
        BankOrder bankOrder = this.bankOrderCreateService.createBankOrder(paymentMode, partnerType, bankOrderDate, senderCompany, senderBankDetails, currency, senderReference, senderLabel, 1);
        bankOrder = (BankOrder)((Object)JPA.save((Model)((Object)bankOrder)));
        int offset = 0;
        try {
            List<PaymentScheduleLine> paymentScheduleLineList;
            while (!(paymentScheduleLineList = this.fetchPaymentScheduleLineDoneList(batch, offset)).isEmpty()) {
                bankOrder = (BankOrder)((Object)this.bankOrderRepo.find(bankOrder.getId()));
                for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
                    PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
                    Partner partner = paymentSchedule.getPartner();
                    BankDetails bankDetails = this.paymentScheduleService.getBankDetails(paymentSchedule);
                    BigDecimal amount = paymentScheduleLine.getInTaxAmount();
                    String receiverReference = paymentScheduleLine.getName();
                    String receiverLabel = paymentScheduleLine.getDebitNumber();
                    BankOrderLine bankOrderLine = this.bankOrderLineService.createBankOrderLine(paymentMode.getBankOrderFileFormat(), null, partner, bankDetails, amount, currency, bankOrderDate, receiverReference, receiverLabel, (Model)paymentScheduleLine);
                    bankOrder.addBankOrderLineListItem(bankOrderLine);
                }
                bankOrder = (BankOrder)((Object)JPA.save((Model)((Object)bankOrder)));
                offset += paymentScheduleLineList.size();
                JPA.clear();
            }
        }
        catch (Exception e) {
            bankOrder = (BankOrder)((Object)this.bankOrderRepo.find(bankOrder.getId()));
            this.bankOrderRepo.remove((Model)((Object)bankOrder));
            throw e;
        }
        bankOrder = (BankOrder)((Object)this.bankOrderRepo.find(bankOrder.getId()));
        bankOrder = (BankOrder)((Object)this.bankOrderRepo.save((Model)((Object)bankOrder)));
        this.bankOrderService.confirm(bankOrder);
        batch = (Batch)((Object)this.batchRepo.find(batch.getId()));
        batch.setBankOrder(bankOrder);
        return bankOrder;
    }

    protected List<PaymentScheduleLine> fetchPaymentScheduleLineDoneList(Batch batch, int offset) {
        return this.getPaymentScheduleLineDoneListQuery(batch).fetch(10, offset);
    }

    private Query<PaymentScheduleLine> getPaymentScheduleLineDoneListQuery(Batch batch) {
        QueryBuilder queryBuilder = QueryBuilder.of(PaymentScheduleLine.class);
        queryBuilder.add(":batch MEMBER OF self.batchSet");
        queryBuilder.bind("batch", (Object)batch);
        queryBuilder.add("self.statusSelect = :statusSelect");
        queryBuilder.bind("statusSelect", (Object)3);
        return queryBuilder.build().order("id");
    }

    protected List<BankOrder> fetchLimitedBankOrderList(Batch batch) {
        return this.getBankOrderListQuery(batch).fetch(10);
    }

    private Query<BankOrder> getBankOrderListQuery(Batch batch) {
        QueryBuilder queryBuilder = QueryBuilder.of(BankOrder.class);
        queryBuilder.add("self.batch = :batch");
        queryBuilder.bind("batch", (Object)batch);
        return queryBuilder.build().order("id");
    }
}

