/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.bankpayment.db.BankPaymentBatch;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.repo.EbicsPartnerRepository;
import com.axelor.apps.bankpayment.ebics.service.EbicsPartnerService;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementService;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchBankStatement
extends AbstractBatch {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int bankStatementCount;
    @Inject
    protected EbicsPartnerRepository ebicsPartnerRepository;
    @Inject
    protected EbicsPartnerService ebicsPartnerService;
    @Inject
    protected BankStatementService bankStatementService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        BankPaymentBatch bankPaymentBatch = this.batch.getBankPaymentBatch();
        Collection<EbicsPartner> ebicsPartners = bankPaymentBatch.getEbicsPartnerSet();
        if (ebicsPartners == null || ebicsPartners.isEmpty()) {
            ebicsPartners = this.getAllActiveEbicsPartners();
        }
        for (EbicsPartner ebicsPartner : ebicsPartners) {
            try {
                List<BankStatement> bankStatementList = this.ebicsPartnerService.getBankStatements((EbicsPartner)((Object)this.ebicsPartnerRepository.find(ebicsPartner.getId())), bankPaymentBatch.getBankStatementFileFormatSet());
                this.bankStatementCount += bankStatementList.size();
                for (BankStatement bankStatement : bankStatementList) {
                    try {
                        this.bankStatementService.runImport(bankStatement, false);
                    }
                    catch (AxelorException e) {
                        this.processError((Exception)((Object)e), e.getCategory(), ebicsPartner);
                    }
                    finally {
                        JPA.clear();
                    }
                }
                this.incrementDone();
            }
            catch (AxelorException e) {
                this.processError((Exception)((Object)e), e.getCategory(), ebicsPartner);
            }
            catch (Exception e) {
                this.processError(e, 4, ebicsPartner);
            }
        }
    }

    protected void processError(Exception cause, int category, EbicsPartner ebicsPartner) {
        log.error(cause.getMessage(), (Throwable)cause);
        this.incrementAnomaly();
        AxelorException exception = new AxelorException((Throwable)cause, (Model)((Object)ebicsPartner), category, "Error with EBICS partner %s: %s", new Object[]{ebicsPartner.getPartnerId(), cause.getMessage()});
        TraceBackService.trace((AxelorException)exception, (String)"bankStatement", (long)this.batch.getId());
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Batch report:"));
        sb.append(" ");
        sb.append(String.format(I18n.get((String)"%d record processed successfully,", (String)"%d records processed successfully,", (int)this.batch.getDone()), this.batch.getDone()));
        sb.append(" ");
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        sb.append("\n");
        sb.append(String.format(I18n.get((String)"Number of retrieved bank statements: %d."), this.bankStatementCount));
        this.addComment(sb.toString());
        super.stop();
    }

    private Collection<EbicsPartner> getAllActiveEbicsPartners() {
        return ((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).all().filter("self.transportEbicsUser.statusSelect = :statusSelect").bind("statusSelect", (Object)3).fetch();
    }

    public Batch bankStatement(BankPaymentBatch bankPaymentBatch) {
        return ((BatchBankStatement)((Object)Beans.get(BatchBankStatement.class))).run(bankPaymentBatch);
    }
}

