/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.AccountingBatchRepository;
import com.axelor.apps.account.db.repo.ReimbursementRepository;
import com.axelor.apps.account.service.ReimbursementExportService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.batch.BatchCreditTransferPartnerReimbursement;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCreditTransferPartnerReimbursementBankPayment
extends BatchCreditTransferPartnerReimbursement {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppAccountService appAccountService;
    protected ReimbursementRepository reimbursementRepo;
    protected BankOrderCreateService bankOrderCreateService;
    protected BankOrderService bankOrderService;
    protected BankOrderLineService bankOrderLineService;
    protected BankOrderRepository bankOrderRepo;

    @Inject
    public BatchCreditTransferPartnerReimbursementBankPayment(PartnerRepository partnerRepo, PartnerService partnerService, ReimbursementExportService reimbursementExportService, AppAccountService appAccountService, ReimbursementRepository reimbursementRepo, BankOrderCreateService bankOrderCreateService, BankOrderService bankOrderService, BankOrderLineService bankOrderLineService, BankOrderRepository bankOrderRepo) {
        super(partnerRepo, partnerService, reimbursementExportService);
        this.appAccountService = appAccountService;
        this.reimbursementRepo = reimbursementRepo;
        this.bankOrderCreateService = bankOrderCreateService;
        this.bankOrderService = bankOrderService;
        this.bankOrderLineService = bankOrderLineService;
        this.bankOrderRepo = bankOrderRepo;
    }

    protected void process() {
        super.process();
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        if (!accountingBatch.getPaymentMode().getGenerateBankOrder().booleanValue()) {
            return;
        }
        Query query = this.reimbursementRepo.all().filter("self.statusSelect = :statusSelect AND self.company = :company");
        query.bind("statusSelect", (Object)3);
        query.bind("company", (Object)accountingBatch.getCompany());
        List reimbursementList = query.fetch();
        if (reimbursementList.isEmpty()) {
            return;
        }
        accountingBatch = (AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId()));
        try {
            this.createBankOrder(accountingBatch, reimbursementList);
        }
        catch (Exception ex) {
            TraceBackService.trace((Throwable)ex);
            logger.error(ex.getLocalizedMessage());
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected BankOrder createBankOrder(AccountingBatch accountingBatch, List<Reimbursement> reimbursementList) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        LocalDate bankOrderDate = accountingBatch.getDueDate() != null ? accountingBatch.getDueDate() : this.appBaseService.getTodayDate(accountingBatch.getCompany());
        BankOrder bankOrder = this.bankOrderCreateService.createBankOrder(accountingBatch.getPaymentMode(), 3, bankOrderDate, accountingBatch.getCompany(), accountingBatch.getBankDetails(), accountingBatch.getCompany().getCurrency(), null, null, 1);
        for (Reimbursement reimbursement : reimbursementList) {
            BankOrderLine bankOrderLine = this.bankOrderLineService.createBankOrderLine(accountingBatch.getPaymentMode().getBankOrderFileFormat(), null, reimbursement.getPartner(), reimbursement.getBankDetails(), reimbursement.getAmountToReimburse(), accountingBatch.getCompany().getCurrency(), bankOrderDate, reimbursement.getRef(), reimbursement.getDescription(), (Model)reimbursement);
            bankOrder.addBankOrderLineListItem(bankOrderLine);
            ((ReimbursementExportService)Beans.get(ReimbursementExportService.class)).reimburse(reimbursement, accountingBatch.getCompany());
        }
        bankOrder = (BankOrder)((Object)this.bankOrderRepo.save((Model)((Object)bankOrder)));
        this.bankOrderService.confirm(bankOrder);
        return bankOrder;
    }
}

