/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.batch.BatchCreditTransferSupplierPayment;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCreditTransferSupplierPaymentBankPayment
extends BatchCreditTransferSupplierPayment {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final BankOrderMergeService bankOrderMergeService;

    @Inject
    public BatchCreditTransferSupplierPaymentBankPayment(AppAccountService appAccountService, InvoiceRepository invoiceRepo, InvoicePaymentCreateService invoicePaymentCreateService, InvoicePaymentRepository invoicePaymentRepository, BankOrderMergeService bankOrderMergeService) {
        super(appAccountService, invoiceRepo, invoicePaymentCreateService, invoicePaymentRepository);
        this.bankOrderMergeService = bankOrderMergeService;
    }

    protected void process() {
        List doneList = this.processInvoices(1);
        if (!doneList.isEmpty()) {
            try {
                this.bankOrderMergeService.mergeFromInvoicePayments(doneList);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e, (String)"invoice", (long)this.batch.getId());
                LOG.error(e.getMessage());
            }
        }
    }
}

