/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.bankpayment.service.batch.BatchBankPaymentService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;

public abstract class BatchDirectDebit
extends BatchStrategy {
    protected boolean generateBankOrderFlag;
    @Inject
    protected BankDetailsService bankDetailsService;
    @Inject
    protected BatchBankPaymentService batchBankPaymentService;
    @Inject
    PaymentScheduleLineRepository paymentScheduleLineRepo;

    protected void start() throws IllegalAccessException {
        super.start();
        PaymentMode directDebitPaymentMode = this.batch.getAccountingBatch().getPaymentMode();
        this.generateBankOrderFlag = directDebitPaymentMode != null && directDebitPaymentMode.getGenerateBankOrder() != false;
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Batch report:")).append(" ");
        sb.append(String.format(I18n.get((String)"%d record processed successfully,", (String)"%d records processed successfully,", (int)this.batch.getDone()) + " ", this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }

    protected BankDetails getCompanyBankDetails(AccountingBatch accountingBatch) {
        BankDetails companyBankDetails = accountingBatch.getBankDetails();
        if (companyBankDetails == null && accountingBatch.getCompany() != null) {
            companyBankDetails = accountingBatch.getCompany().getDefaultBankDetails();
        }
        if (companyBankDetails == null && this.generateBankOrderFlag) {
            throw new IllegalArgumentException(I18n.get((String)"Company bank details is missing in batch."));
        }
        return companyBankDetails;
    }
}

