/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.service.PaymentScheduleLineService;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.bankpayment.db.BankPaymentConfig;
import com.axelor.apps.bankpayment.service.batch.BatchDirectDebit;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDirectDebitPaymentSchedule
extends BatchDirectDebit {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void process() {
        this.processPaymentScheduleLines(1);
        if (this.batchBankPaymentService.paymentScheduleLineDoneListExists(this.batch) && this.generateBankOrderFlag) {
            try {
                this.findBatch();
                this.batchBankPaymentService.createBankOrderFromPaymentScheduleLines(this.batch);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e, (String)"directDebit", (long)this.batch.getId());
                logger.error(e.getLocalizedMessage());
            }
        }
    }

    protected void processPaymentScheduleLines(int paymentScheduleType) {
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        if (this.generateBankOrderFlag) {
            Preconditions.checkNotNull((Object)((Object)accountingBatch.getCompany()), (Object)I18n.get((String)"Company is missing."));
            Preconditions.checkNotNull((Object)((Object)accountingBatch.getPaymentMode()), (Object)I18n.get((String)"Payment method is missing."));
            BankDetails companyBankDetails = this.getCompanyBankDetails(accountingBatch);
            AccountManagement accountManagement = ((PaymentModeService)Beans.get(PaymentModeService.class)).getAccountManagement(accountingBatch.getPaymentMode(), accountingBatch.getCompany(), companyBankDetails);
            Preconditions.checkNotNull((Object)((Object)accountManagement), (Object)I18n.get((String)"Account management is missing."));
            Preconditions.checkNotNull((Object)((Object)accountManagement.getBankDetails()), (Object)I18n.get((String)"Bank details in account management is missing."));
            Preconditions.checkNotNull((Object)companyBankDetails.getCurrency(), (Object)I18n.get((String)"Currency in company bank details is missing."));
            Preconditions.checkArgument((boolean)new File(accountingBatch.getPaymentMode().getBankOrderExportFolderPath()).exists(), (Object)String.format(I18n.get((String)"Bank order export folder does not exist: %s"), accountingBatch.getPaymentMode().getBankOrderExportFolderPath()));
            BankPaymentConfigService bankPaymentConfigService = (BankPaymentConfigService)Beans.get(BankPaymentConfigService.class);
            try {
                BankPaymentConfig bankPaymentConfig = bankPaymentConfigService.getBankPaymentConfig(accountingBatch.getCompany());
                bankPaymentConfigService.getIcsNumber(bankPaymentConfig);
            }
            catch (AxelorException e) {
                throw new RuntimeException(e);
            }
        }
        QueryBuilder queryBuilder = QueryBuilder.of(PaymentScheduleLine.class);
        queryBuilder.add("self.paymentSchedule.statusSelect = :paymentScheduleStatusSelect");
        queryBuilder.bind("paymentScheduleStatusSelect", (Object)2);
        queryBuilder.add("self.paymentSchedule.typeSelect = :paymentScheduleTypeSelect");
        queryBuilder.bind("paymentScheduleTypeSelect", (Object)paymentScheduleType);
        queryBuilder.add("self.statusSelect = :statusSelect");
        queryBuilder.bind("statusSelect", (Object)2);
        LocalDate dueDate = accountingBatch.getDueDate() != null ? accountingBatch.getDueDate() : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(accountingBatch.getCompany());
        queryBuilder.add("self.scheduleDate <= :dueDate");
        queryBuilder.bind("dueDate", (Object)dueDate);
        if (accountingBatch.getCompany() != null) {
            queryBuilder.add("self.paymentSchedule.company IS NULL OR self.paymentSchedule.company = :company");
            queryBuilder.bind("company", (Object)accountingBatch.getCompany());
        }
        queryBuilder.add("self.paymentSchedule.partner.id NOT IN (SELECT DISTINCT partner.id FROM Partner partner LEFT JOIN partner.blockingList blocking WHERE blocking.blockingSelect = :blockingSelect AND blocking.blockingToDate >= :blockingToDate)");
        queryBuilder.bind("blockingSelect", (Object)BlockingRepository.DEBIT_BLOCKING);
        queryBuilder.bind("blockingToDate", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(accountingBatch.getCompany()));
        if (accountingBatch.getBankDetails() != null) {
            HashSet bankDetailsSet = Sets.newHashSet((Object[])new BankDetails[]{accountingBatch.getBankDetails()});
            if (accountingBatch.getIncludeOtherBankAccounts().booleanValue() && this.appBaseService.getAppBase().getManageMultiBanks().booleanValue()) {
                bankDetailsSet.addAll(accountingBatch.getCompany().getBankDetailsList());
            }
            queryBuilder.add("self.paymentSchedule.companyBankDetails IS NULL OR self.paymentSchedule.companyBankDetails IN (:bankDetailsSet)");
            queryBuilder.bind("bankDetailsSet", (Object)bankDetailsSet);
        }
        if (accountingBatch.getPaymentMode() != null) {
            queryBuilder.add("self.paymentSchedule.paymentMode IS NULL OR self.paymentSchedule.paymentMode = :paymentMode");
            queryBuilder.bind("paymentMode", (Object)accountingBatch.getPaymentMode());
        }
        queryBuilder.add(":batch NOT MEMBER OF self.batchSet");
        queryBuilder.bind("batch", (Object)this.batch);
        this.processQuery((QueryBuilder<PaymentScheduleLine>)queryBuilder);
    }

    private void processQuery(QueryBuilder<PaymentScheduleLine> queryBuilder) {
        List paymentScheduleLineList;
        Query query = queryBuilder.build();
        PaymentScheduleService paymentScheduleService = (PaymentScheduleService)Beans.get(PaymentScheduleService.class);
        PaymentScheduleLineService paymentScheduleLineService = (PaymentScheduleLineService)Beans.get(PaymentScheduleLineService.class);
        BankDetailsRepository bankDetailsRepo = (BankDetailsRepository)((Object)Beans.get(BankDetailsRepository.class));
        BankDetails companyBankDetails = this.getCompanyBankDetails(this.batch.getAccountingBatch());
        while (!(paymentScheduleLineList = query.fetch(10)).isEmpty()) {
            this.findBatch();
            companyBankDetails = (BankDetails)((Object)bankDetailsRepo.find(companyBankDetails.getId()));
            PaymentMode directDebitPaymentMode = this.batch.getAccountingBatch().getPaymentMode();
            for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
                try {
                    if (this.generateBankOrderFlag) {
                        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
                        BankDetails bankDetails = paymentScheduleService.getBankDetails(paymentSchedule);
                        Preconditions.checkArgument((boolean)bankDetails.getActive(), (Object)(bankDetails.getPartner() != null ? bankDetails.getPartner().getFullName() + " - " + I18n.get((String)"Bank details are inactive.") : I18n.get((String)"Bank details are inactive.")));
                        if (directDebitPaymentMode.getOrderTypeSelect() == 2) {
                            Partner partner = paymentSchedule.getPartner();
                            Preconditions.checkNotNull((Object)((Object)partner), (Object)I18n.get((String)"Partner is missing."));
                            Preconditions.checkNotNull((Object)partner.getActiveUmr(), (Object)I18n.get((String)"Partner active UMR is missing."));
                        }
                    }
                    paymentScheduleLineService.createPaymentMove(paymentScheduleLine, companyBankDetails, directDebitPaymentMode);
                    this.incrementDone(paymentScheduleLine);
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)e, (String)"directDebit", (long)this.batch.getId());
                    this.incrementAnomaly(paymentScheduleLine);
                    break;
                }
            }
            JPA.clear();
        }
    }

    protected void incrementDone(PaymentScheduleLine paymentScheduleLine) {
        paymentScheduleLine.addBatchSetItem(this.batch);
        this._incrementDone();
    }

    protected void incrementAnomaly(PaymentScheduleLine paymentScheduleLine) {
        this.findBatch();
        paymentScheduleLine = (PaymentScheduleLine)this.paymentScheduleLineRepo.find(paymentScheduleLine.getId());
        paymentScheduleLine.addBatchSetItem(this.batch);
        this._incrementAnomaly();
    }
}

