/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.batch;

import com.axelor.apps.bankpayment.db.BankPaymentBatch;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.BankPaymentBatchRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsCertificateRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsUserRepository;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;

public class BatchEbicsCertificate
extends AbstractBatch {
    protected BankPaymentBatch bankPaymentBatch;
    @Inject
    private TemplateRepository templateRepo;
    @Inject
    private TemplateMessageService templateMessageService;

    protected void start() throws IllegalAccessException {
        super.start();
        this.bankPaymentBatch = (BankPaymentBatch)((Object)((BankPaymentBatchRepository)((Object)Beans.get(BankPaymentBatchRepository.class))).find(this.batch.getBankPaymentBatch().getId()));
    }

    protected void process() {
        Template template = (Template)((Object)this.templateRepo.find(this.bankPaymentBatch.getTemplate().getId()));
        List users = ((EbicsUserRepository)((Object)Beans.get(EbicsUserRepository.class))).all().filter("self.a005Certificate != null OR self.e002Certificate != null OR self.x002Certificate != null").fetch();
        HashSet<EbicsCertificate> certificatesSet = new HashSet<EbicsCertificate>();
        LocalDate today = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(this.bankPaymentBatch.getCompany());
        LocalDate commingDay = today.plusDays(this.bankPaymentBatch.getDaysNbr().intValue());
        for (EbicsUser user : users) {
            if (user.getA005Certificate() != null && user.getA005Certificate().getValidTo().isBefore(commingDay)) {
                certificatesSet.add(user.getA005Certificate());
            }
            if (user.getE002Certificate() != null && user.getE002Certificate().getValidTo().isBefore(commingDay)) {
                certificatesSet.add(user.getE002Certificate());
            }
            if (user.getX002Certificate() == null || !user.getX002Certificate().getValidTo().isBefore(commingDay)) continue;
            certificatesSet.add(user.getX002Certificate());
        }
        certificatesSet.addAll(((EbicsCertificateRepository)((Object)Beans.get(EbicsCertificateRepository.class))).all().filter("self.ebicsBank != null AND self.validTo <= ?1", new Object[]{commingDay}).fetch());
        for (EbicsCertificate certificate : certificatesSet) {
            certificate.addBatchSetItem((Batch)((Object)this.batchRepo.find(this.batch.getId())));
            try {
                this.templateMessageService.generateMessage((Model)((Object)certificate), template);
            }
            catch (AxelorException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public Batch ebicsCertificate(BankPaymentBatch bankPaymentBatch) {
        return ((BatchEbicsCertificate)((Object)Beans.get(BatchEbicsCertificate.class))).run(bankPaymentBatch);
    }
}

