/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.cfonb;

import com.axelor.apps.tool.StringTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfonbToolService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final String STATUS_MANDATORY = "M";
    public final String STATUS_OPTIONAL = "O";
    public final String STATUS_DEPENDENT = "D";
    public final String STATUS_NOT_USED = "N";
    public final String FORMAT_ALPHA_NUMERIC = "AN";
    public final String FORMAT_NUMERIC = "N";
    public final String FORMAT_ALPHA = "A";

    public void testDigital(String value, String zone) throws AxelorException {
        if (!StringTool.isDigital((String)value)) {
            throw new AxelorException(4, I18n.get((String)"Zone %s (%s) must be of the numeric type"), new Object[]{zone, value});
        }
    }

    public void testLength(String s, int size) throws AxelorException {
        if (s.length() != size) {
            throw new AxelorException(4, I18n.get((String)"The record is not %s characters"), new Object[]{size});
        }
    }

    public List<String> toUpperCase(List<String> cFONB) {
        ArrayList<String> upperCase = new ArrayList<String>();
        for (String s : cFONB) {
            upperCase.add(StringTool.deleteAccent((String)s.toUpperCase()));
        }
        return upperCase;
    }

    public String toUpperCase(String record) {
        return StringTool.deleteAccent((String)record.toUpperCase());
    }

    public void checkFilled(String value, String numZone) throws AxelorException {
        if (Strings.isNullOrEmpty((String)value)) {
            throw new AxelorException(4, I18n.get((String)"Zone %s is empty"), new Object[]{numZone});
        }
    }

    public String normalizeNumber(BigDecimal amount) {
        return amount.setScale(2).toString().replace(".", "");
    }

    public String createZone(String numOfZone, String value, String status, String format, int length) throws AxelorException {
        String zone = value;
        switch (status) {
            case "M": {
                this.checkFilled(zone, numOfZone);
                break;
            }
            case "O": {
                if (zone != null) break;
                zone = "";
                break;
            }
            case "D": {
                if (zone != null) break;
                zone = "";
                break;
            }
            case "N": {
                zone = "";
                break;
            }
        }
        switch (format) {
            case "AN": {
                zone = StringTool.deleteAccent((String)zone);
                zone = StringTool.fillStringRight((String)zone, (char)' ', (int)length);
                break;
            }
            case "N": {
                this.testDigital(zone, numOfZone);
                zone = StringTool.fillStringLeft((String)zone, (char)'0', (int)length);
                break;
            }
            case "A": {
                zone = StringTool.deleteAccent((String)zone);
                zone = StringTool.fillStringRight((String)zone, (char)' ', (int)length);
                break;
            }
        }
        return zone;
    }

    public String createZone(String numOfZone, int value, String status, String format, int length) throws AxelorException {
        return this.createZone(numOfZone, Integer.toString(value), status, format, length);
    }

    public String createZone(String numOfZone, BigDecimal value, String status, String format, int length) throws AxelorException {
        return this.createZone(numOfZone, this.normalizeNumber(value), status, format, length);
    }

    public String readZone(String numOfZone, String lineContent, String status, String format, int position, int length) throws AxelorException {
        String zone = lineContent.substring(position - 1, position + length - 1);
        switch (status) {
            case "M": {
                this.checkFilled(zone, numOfZone);
                break;
            }
            case "O": {
                if (!zone.replaceAll(" ", "").isEmpty()) break;
                return null;
            }
            case "D": {
                if (!zone.replaceAll(" ", "").isEmpty()) break;
                return null;
            }
            case "N": {
                return null;
            }
        }
        switch (format) {
            case "AN": {
                zone = zone.trim();
                break;
            }
            case "N": {
                this.testDigital(zone.trim(), numOfZone);
                break;
            }
            case "A": {
                zone = zone.trim();
                break;
            }
        }
        this.log.debug("Read zone : {}, status : {}, format : {}, position : {}, length : {}, result : {}", new Object[]{numOfZone, status, format, position, length, zone});
        return zone;
    }

    public List<String> createCFONBFile(String senderRecord, List<String> recipientRecord, String totalRecord) {
        ArrayList<String> cFONB = new ArrayList<String>();
        cFONB.add(senderRecord);
        cFONB.addAll(recipientRecord);
        cFONB.add(totalRecord);
        return cFONB;
    }
}

