/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.invoice.payment;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateServiceImpl;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.bankpayment.service.invoice.payment.InvoicePaymentCreateServiceBankPay;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.TypedQuery;

public class InvoicePaymentCreateServiceBankPayImpl
extends InvoicePaymentCreateServiceImpl
implements InvoicePaymentCreateServiceBankPay {
    @Inject
    public InvoicePaymentCreateServiceBankPayImpl(InvoicePaymentRepository invoicePaymentRepository, InvoicePaymentToolService invoicePaymentToolService, CurrencyService currencyService, AppBaseService appBaseService) {
        super(invoicePaymentRepository, invoicePaymentToolService, currencyService, appBaseService);
    }

    @Transactional(rollbackOn={Exception.class})
    public List<InvoicePayment> createMassInvoicePayment(List<Long> invoiceList, PaymentMode paymentMode, BankDetails companyBankDetails, LocalDate paymentDate, LocalDate bankDepositDate, String chequeNumber) throws AxelorException {
        List invoicePaymentList = super.createMassInvoicePayment(invoiceList, paymentMode, companyBankDetails, paymentDate, bankDepositDate, chequeNumber);
        if (!((AppBaseService)Beans.get(AppBaseService.class)).isApp("bank-payment")) {
            return invoicePaymentList;
        }
        if (invoicePaymentList.isEmpty()) {
            return invoicePaymentList;
        }
        if (paymentMode.getGenerateBankOrder().booleanValue()) {
            ((BankOrderMergeService)Beans.get(BankOrderMergeService.class)).mergeFromInvoicePayments(invoicePaymentList);
        }
        return invoicePaymentList;
    }

    public List<Long> getInvoiceIdsToPay(List<Long> invoiceIdList) throws AxelorException {
        List invoiceToPay = super.getInvoiceIdsToPay(invoiceIdList);
        if (!((AppBaseService)Beans.get(AppBaseService.class)).isApp("bank-payment")) {
            return invoiceToPay;
        }
        for (Long invoiceId : invoiceToPay) {
            Invoice invoice = (Invoice)((InvoiceRepository)Beans.get(InvoiceRepository.class)).find(invoiceId);
            if (!invoice.getPaymentMode().getGenerateBankOrder().booleanValue()) continue;
            this.checkBankOrderAlreadyExist(invoice);
        }
        return invoiceToPay;
    }

    @Override
    public void checkBankOrderAlreadyExist(Invoice invoice) throws AxelorException {
        TypedQuery q = JPA.em().createQuery("select bankOrder FROM Invoice invoice LEFT JOIN InvoicePayment invoicePayment on invoice.id = invoicePayment.invoice LEFT JOIN BankOrder as bankOrder on invoicePayment.bankOrder = bankOrder.id WHERE invoice.id = :id AND (bankOrder.statusSelect = :statusSelectDraft OR bankOrder.statusSelect = :statusSelectAwaiting)", BankOrder.class);
        q.setParameter("id", (Object)invoice.getId());
        q.setParameter("statusSelectDraft", (Object)1);
        q.setParameter("statusSelectAwaiting", (Object)2);
        List listbankOrder = q.getResultList();
        if (listbankOrder != null && !listbankOrder.isEmpty()) {
            throw new AxelorException(5, I18n.get((String)"A bank order %s already exist for the invoice %s."), new Object[]{((BankOrder)((Object)listbankOrder.get(0))).getBankOrderSeq(), invoice.getInvoiceId()});
        }
    }
}

