/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.invoice.payment;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentValidateServiceImpl;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.Company;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class InvoicePaymentValidateServiceBankPayImpl
extends InvoicePaymentValidateServiceImpl {
    protected BankOrderCreateService bankOrderCreateService;
    protected BankOrderService bankOrderService;

    @Inject
    public InvoicePaymentValidateServiceBankPayImpl(PaymentModeService paymentModeService, MoveService moveService, MoveLineService moveLineService, AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepository, ReconcileService reconcileService, BankOrderCreateService bankOrderCreateService, BankOrderService bankOrderService, InvoicePaymentToolService invoicePaymentToolService) {
        super(paymentModeService, moveService, moveLineService, accountConfigService, invoicePaymentRepository, reconcileService, invoicePaymentToolService);
        this.bankOrderCreateService = bankOrderCreateService;
        this.bankOrderService = bankOrderService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validate(InvoicePayment invoicePayment, boolean force) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        if (!force && invoicePayment.getStatusSelect() != 0) {
            return;
        }
        Invoice invoice = invoicePayment.getInvoice();
        PaymentMode paymentMode = invoicePayment.getPaymentMode();
        if (paymentMode == null) {
            throw new AxelorException(1, I18n.get((String)"Payment mode is missing on the invoice %s"), new Object[]{invoice.getInvoiceId()});
        }
        int typeSelect = paymentMode.getTypeSelect();
        int inOutSelect = paymentMode.getInOutSelect();
        if (typeSelect == 2 && inOutSelect == 1 || typeSelect == 9 && inOutSelect == 2 && paymentMode.getGenerateBankOrder().booleanValue()) {
            invoicePayment.setStatusSelect(3);
        } else {
            invoicePayment.setStatusSelect(1);
        }
        Company company = invoice.getCompany();
        if (this.accountConfigService.getAccountConfig(company).getGenerateMoveForInvoicePayment().booleanValue() && !paymentMode.getGenerateBankOrder().booleanValue()) {
            invoicePayment = this.createMoveForInvoicePayment(invoicePayment);
        } else {
            ((AccountingSituationService)Beans.get(AccountingSituationService.class)).updateCustomerCredit(invoicePayment.getInvoice().getPartner());
            invoicePayment = (InvoicePayment)((Object)this.invoicePaymentRepository.save((Model)((Object)invoicePayment)));
        }
        if (paymentMode.getGenerateBankOrder().booleanValue()) {
            this.createBankOrder(invoicePayment);
        }
        this.invoicePaymentToolService.updateAmountPaid(invoice);
        if (invoice != null && invoice.getOperationSubTypeSelect() == 2) {
            invoicePayment.setTypeSelect(1);
        }
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateFromBankOrder(InvoicePayment invoicePayment, boolean force) throws AxelorException {
        invoicePayment.setStatusSelect(1);
        Company company = invoicePayment.getInvoice().getCompany();
        if (this.accountConfigService.getAccountConfig(company).getGenerateMoveForInvoicePayment().booleanValue()) {
            invoicePayment = this.createMoveForInvoicePayment(invoicePayment);
        } else {
            ((AccountingSituationService)Beans.get(AccountingSituationService.class)).updateCustomerCredit(invoicePayment.getInvoice().getPartner());
            invoicePayment = (InvoicePayment)((Object)this.invoicePaymentRepository.save((Model)((Object)invoicePayment)));
        }
        this.invoicePaymentToolService.updateAmountPaid(invoicePayment.getInvoice());
    }

    @Transactional(rollbackOn={Exception.class})
    public void createBankOrder(InvoicePayment invoicePayment) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        BankOrder bankOrder = this.bankOrderCreateService.createBankOrder(invoicePayment);
        if (invoicePayment.getPaymentMode().getAutoConfirmBankOrder().booleanValue()) {
            this.bankOrderService.confirm(bankOrder);
        }
        invoicePayment.setBankOrder(bankOrder);
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
    }
}

