/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMergeService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BankOrderController {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void confirm(ActionRequest request, ActionResponse response) {
        try {
            BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
            bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
            if (bankOrder != null) {
                ((BankOrderService)Beans.get(BankOrderService.class)).confirm(bankOrder);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void sign(ActionRequest request, ActionResponse response) throws AxelorException {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
        try {
            ActionView.ActionViewBuilder confirmView = ActionView.define((String)"Sign bank order").model(BankOrder.class.getName()).add("form", "bank-order-sign-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").param("forceEdit", "true").context("_showRecord", (Object)bankOrder.getId());
            response.setView(confirmView.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        BankOrderService bankOrderService = (BankOrderService)Beans.get(BankOrderService.class);
        BankOrder bankOrder = (BankOrder)((Object)context.asType(BankOrder.class));
        bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
        try {
            EbicsUser ebicsUser = bankOrder.getSignatoryEbicsUser();
            if (ebicsUser == null) {
                response.setError(I18n.get((String)"Please select a user name"));
            } else if (ebicsUser.getEbicsPartner().getEbicsTypeSelect() == 1) {
                bankOrderService.validate(bankOrder);
            } else {
                if (context.get((Object)"password") == null) {
                    response.setError(I18n.get((String)"Incorrect password, please try again"));
                }
                if (context.get((Object)"password") != null) {
                    String password = (String)context.get((Object)"password");
                    if (ebicsUser.getPassword() == null || !ebicsUser.getPassword().equals(password)) {
                        response.setValue("password", (Object)"");
                        response.setError(I18n.get((String)"Incorrect password, please try again"));
                    } else {
                        bankOrderService.validate(bankOrder);
                    }
                }
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void realize(ActionRequest request, ActionResponse response) {
        try {
            BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
            bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
            if (bankOrder != null) {
                ((BankOrderService)Beans.get(BankOrderService.class)).realize(bankOrder);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        String name = I18n.get((String)"Bank Order") + " " + bankOrder.getBankOrderSeq();
        String fileLink = ReportFactory.createReport((String)"BankOrder.rptdesign", (String)(name + "-${date}")).addParam("BankOrderId", (Object)bankOrder.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", bankOrder.getSenderCompany() != null ? bankOrder.getSenderCompany().getTimezone() : null).generate().getFileLink();
        this.log.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void merge(ActionRequest request, ActionResponse response) {
        try {
            List listSelectedBankOrder = (List)request.getContext().get((Object)"_ids");
            BankOrderRepository bankOrderRepository = (BankOrderRepository)((Object)Beans.get(BankOrderRepository.class));
            ArrayList bankOrderList = Lists.newArrayList();
            if (listSelectedBankOrder != null) {
                for (Integer bankOrderId : listSelectedBankOrder) {
                    BankOrder bankOrder = (BankOrder)((Object)bankOrderRepository.find(bankOrderId.longValue()));
                    if (bankOrder == null) continue;
                    bankOrderList.add(bankOrder);
                }
                BankOrder bankOrder = ((BankOrderMergeService)Beans.get(BankOrderMergeService.class)).mergeBankOrders(bankOrderList);
                response.setView(ActionView.define((String)I18n.get((String)"Bank Order")).model(BankOrder.class.getName()).add("form", "bank-order-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(bankOrder.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillSignatoryEbicsUser(ActionRequest request, ActionResponse response) {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        if (bankOrder.getSenderBankDetails() != null) {
            EbicsUser ebicsUser = ((BankOrderService)Beans.get(BankOrderService.class)).getDefaultEbicsUserFromBankDetails(bankOrder.getSenderBankDetails());
            bankOrder.setSignatoryEbicsUser(ebicsUser);
            response.setValues((Object)bankOrder);
        }
    }

    public void setBankDetailDomain(ActionRequest request, ActionResponse response) {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        String domain = ((BankOrderService)Beans.get(BankOrderService.class)).createDomainForBankDetails(bankOrder);
        if (domain.equals("")) {
            response.setAttr("senderBankDetails", "domain", (Object)"self.id IN (0)");
        } else {
            response.setAttr("senderBankDetails", "domain", (Object)domain);
        }
    }

    public void fillBankDetails(ActionRequest request, ActionResponse response) {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        BankDetails bankDetails = ((BankOrderService)Beans.get(BankOrderService.class)).getDefaultBankDetails(bankOrder);
        response.setValue("senderBankDetails", (Object)bankDetails);
    }

    public void resetReceivers(ActionRequest request, ActionResponse response) {
        try {
            BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
            ((BankOrderService)Beans.get(BankOrderService.class)).resetReceivers(bankOrder);
            response.setValue("bankOrderLineList", bankOrder.getBankOrderLineList());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void displayBankOrderLines(ActionRequest actionRequest, ActionResponse response) {
        try {
            String linesDomain = (String)actionRequest.getContext().get((Object)"_linesDomain");
            response.setView(((BankOrderService)Beans.get(BankOrderService.class)).buildBankOrderLineView("bank-order-line-grid", "bank-order-line-form", linesDomain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void displayBankOrderLinesBankToBank(ActionRequest actionRequest, ActionResponse response) {
        try {
            String linesDomain = (String)actionRequest.getContext().get((Object)"_linesDomain");
            response.setView(((BankOrderService)Beans.get(BankOrderService.class)).buildBankOrderLineView("bank-order-line-bank-to-bank-grid", "bank-order-line-form", linesDomain).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
            bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
            ((BankOrderService)Beans.get(BankOrderService.class)).cancelBankOrder(bankOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setStatusCorrect(ActionRequest request, ActionResponse response) {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
        ((BankOrderService)Beans.get(BankOrderService.class)).setStatusToDraft(bankOrder);
        response.setReload(true);
    }

    public void setStatusReject(ActionRequest request, ActionResponse response) {
        BankOrder bankOrder = (BankOrder)((Object)request.getContext().asType(BankOrder.class));
        bankOrder = (BankOrder)((Object)((BankOrderRepository)((Object)Beans.get(BankOrderRepository.class))).find(bankOrder.getId()));
        ((BankOrderService)Beans.get(BankOrderService.class)).setStatusToRejected(bankOrder);
        response.setReload(true);
    }
}

