/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectStore;
import net.fortuna.ical4j.connector.dav.CalDavCalendarCollection;
import net.fortuna.ical4j.connector.dav.CalDavCalendarStore;
import net.fortuna.ical4j.connector.dav.DavConstants;
import net.fortuna.ical4j.connector.dav.enums.MediaType;
import net.fortuna.ical4j.connector.dav.enums.ResourceType;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDavObjectCollection<T>
implements ObjectCollection<T> {
    private final AbstractDavObjectStore<?> store;
    private final String id;
    protected DavPropertySet properties;
    private String _ownerName = null;
    private boolean _isReadOnly;

    public AbstractDavObjectCollection(AbstractDavObjectStore<?> store, String id) {
        this.store = store;
        this.id = id;
        this.properties = new DavPropertySet();
    }

    public final AbstractDavObjectStore<?> getStore() {
        return this.store;
    }

    public final String getId() {
        return this.id;
    }

    public final String getPath() {
        if (!this.getId().endsWith("/")) {
            return this.getId() + "/";
        }
        return this.getId();
    }

    public ResourceType[] getResourceTypes() {
        ArrayList<ResourceType> resourceTypes = new ArrayList<ResourceType>();
        try {
            ArrayList resourceTypeProp = this.getProperty(BaseDavPropertyName.RESOURCETYPE, ArrayList.class);
            if (resourceTypeProp != null) {
                for (Node child : resourceTypeProp) {
                    ResourceType type;
                    String nameNode;
                    if (!(child instanceof Element) || (nameNode = child.getNodeName()) == null || (type = ResourceType.findByDescription(nameNode)) == null) continue;
                    resourceTypes.add(type);
                }
            }
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
        return resourceTypes.toArray(new ResourceType[resourceTypes.size()]);
    }

    public MediaType[] getSupportedMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        try {
            ArrayList mediaTypeProp = this.getProperty(CalDavPropertyName.SUPPORTED_CALENDAR_DATA, ArrayList.class);
            if (mediaTypeProp != null) {
                for (Node child : mediaTypeProp) {
                    String version;
                    String contentType;
                    MediaType type;
                    String nameNode;
                    if (!(child instanceof Element) || (nameNode = child.getNodeName()) == null || !"calendar-data".equals(nameNode) || (type = MediaType.findByContentTypeAndVersion(contentType = ((Element)child).getAttribute("content-type"), version = ((Element)child).getAttribute("version"))) == null) continue;
                    mediaTypes.add(type);
                }
            }
            return mediaTypes.toArray(new MediaType[mediaTypes.size()]);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getQuotaAvailableBytes() {
        try {
            Long calTimezoneProp = this.getProperty(BaseDavPropertyName.QUOTA_AVAILABLE_BYTES, Long.class);
            if (calTimezoneProp != null) {
                return calTimezoneProp;
            }
            return new Long(0L);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getQuotaUsedBytes() {
        try {
            Long calTimezoneProp = this.getProperty(BaseDavPropertyName.QUOTA_USED_BYTES, Long.class);
            if (calTimezoneProp != null) {
                return calTimezoneProp;
            }
            return new Long(0L);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOwnerHref() {
        String ownerHref = null;
        try {
            ArrayList ownerProp = this.getProperty(SecurityConstants.OWNER, ArrayList.class);
            if (ownerProp != null) {
                for (Node child : ownerProp) {
                    String nameNode;
                    if (!(child instanceof Element) || (nameNode = child.getNodeName()) == null || !"href".equals(nameNode)) continue;
                    ownerHref = child.getTextContent();
                }
            }
            return ownerHref;
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOwnerName() {
        if (this._ownerName == null && this.getOwnerHref() != null) {
            try {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.DISPLAYNAME);
                PropFindMethod aGet = new PropFindMethod(this.getOwnerHref(), nameSet, 0);
                aGet.setDoAuthentication(true);
                this.getStore().getClient().execute((HttpMethodBase)aGet);
                if (aGet.getStatusCode() == 207) {
                    MultiStatus multiStatus = aGet.getResponseBodyAsMultiStatus();
                    MultiStatusResponse[] responses = multiStatus.getResponses();
                    for (int i = 0; i < responses.length; ++i) {
                        MultiStatusResponse msResponse = responses[i];
                        DavPropertySet foundProperties = msResponse.getProperties(200);
                        DavProperty displayNameProp = foundProperties.get(DavPropertyName.DISPLAYNAME);
                        if (displayNameProp == null) continue;
                        this._ownerName = (String)displayNameProp.getValue();
                    }
                }
            }
            catch (IOException | DavException e) {
                throw new RuntimeException(e);
            }
        }
        return this._ownerName;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public final <P> P getProperty(DavPropertyName propertyName, Class<P> type) throws IOException, ObjectStoreException, DavException {
        DavPropertySet props = this.properties;
        if (props.get(propertyName) != null) {
            Object value = props.get(propertyName).getValue();
            try {
                if (Collection.class.isAssignableFrom(type)) {
                    P result = type.newInstance();
                    if (value instanceof Collection) {
                        ((Collection)result).addAll((Collection)value);
                    }
                    return result;
                }
                Constructor<P> constructor = type.getConstructor(value.getClass());
                return constructor.newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public final void delete() throws HttpException, IOException, ObjectStoreException {
        DeleteMethod deleteMethod = new DeleteMethod(this.getPath());
        this.getStore().getClient().execute((HttpMethodBase)deleteMethod);
        if (!deleteMethod.succeeded()) {
            throw new ObjectStoreException(deleteMethod.getStatusCode() + ": " + deleteMethod.getStatusText());
        }
    }

    public final boolean exists() throws HttpException, IOException, ObjectStoreException {
        DavPropertyNameSet principalsProps = CalDavCalendarCollection.propertiesForFetch();
        PropFindMethod getMethod = new PropFindMethod(this.getPath(), principalsProps, 0);
        this.getStore().getClient().execute((HttpMethodBase)getMethod);
        if (getMethod.getStatusCode() == 207) {
            return true;
        }
        if (getMethod.getStatusCode() == 200) {
            return true;
        }
        if (getMethod.getStatusCode() == 404) {
            return false;
        }
        throw new ObjectStoreException(getMethod.getStatusLine().toString());
    }

    protected static List<CalDavCalendarCollection> collectionsFromResponse(CalDavCalendarStore store, MultiStatusResponse[] responses) {
        ArrayList<CalDavCalendarCollection> collections = new ArrayList<CalDavCalendarCollection>();
        for (int i = 0; i < responses.length; ++i) {
            MultiStatusResponse msResponse = responses[i];
            DavPropertySet foundProperties = msResponse.getProperties(200);
            String collectionUri = msResponse.getHref();
            for (int j = 0; j < responses[i].getStatus().length; ++j) {
                if (responses[i].getStatus()[j].getStatusCode() != 200) continue;
                boolean isCalendarCollection = false;
                DavPropertySet _properties = new DavPropertySet();
                DavPropertyIterator iNames = foundProperties.iterator();
                while (iNames.hasNext()) {
                    Object value;
                    DavProperty property = iNames.nextProperty();
                    if (property == null) continue;
                    _properties.add(property);
                    if (!"resourcetype".equals(property.getName().getName()) || !DavConstants.NAMESPACE.equals((Object)property.getName().getNamespace()) || !((value = property.getValue()) instanceof ArrayList)) continue;
                    for (Node child : (ArrayList)value) {
                        ResourceType type;
                        String nameNode;
                        if (!(child instanceof Element) || (nameNode = child.getLocalName()) == null || (type = ResourceType.findByDescription(nameNode)) == null) continue;
                        if (type.equals((Object)ResourceType.CALENDAR)) {
                            isCalendarCollection = true;
                        }
                        if (type.equals((Object)ResourceType.CALENDAR_PROXY_READ)) {
                            isCalendarCollection = true;
                        }
                        if (!type.equals((Object)ResourceType.CALENDAR_PROXY_WRITE)) continue;
                        isCalendarCollection = true;
                    }
                }
                if (!isCalendarCollection) continue;
                collections.add(new CalDavCalendarCollection(store, collectionUri, _properties));
            }
        }
        return collections;
    }
}

