/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import net.fortuna.ical4j.connector.CardCollection;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.jcr.AbstractJcrObjectCollection;
import net.fortuna.ical4j.connector.jcr.JcrCard;
import net.fortuna.ical4j.connector.jcr.JcrCardDao;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Uid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JcrCardCollection
extends AbstractJcrObjectCollection<VCard>
implements CardCollection {
    private static final Log LOG = LogFactory.getLog(JcrCardCollection.class);
    private JcrCardDao cardDao;
    private static final long serialVersionUID = -3923756409472505791L;

    @Override
    public void addCard(VCard card) throws ObjectStoreException, ConstraintViolationException {
        List<JcrCard> jcrCards;
        try {
            try {
                this.getNode().getNode("cards");
            }
            catch (PathNotFoundException e) {
                this.getNode().addNode("cards");
            }
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException("Unexpected error", e);
        }
        JcrCard jcrCard = null;
        boolean update = false;
        Uid uid = (Uid)card.getProperty(Property.Id.UID);
        if (uid != null && !(jcrCards = this.getCardDao().findByUid(this.getStore().getJcrom().getPath((Object)this) + "/cards", uid.getValue())).isEmpty()) {
            jcrCard = jcrCards.get(0);
            update = true;
        }
        if (jcrCard == null) {
            jcrCard = new JcrCard();
        }
        jcrCard.setCard(card);
        if (update) {
            this.getCardDao().update((Object)jcrCard);
        } else {
            this.getCardDao().create(this.getStore().getJcrom().getPath((Object)this) + "/cards", (Object)jcrCard);
        }
    }

    public VCard[] getComponents() throws ObjectStoreException {
        ArrayList<VCard> cards = new ArrayList<VCard>();
        List jcrCards = this.getCardDao().findAll(this.getStore().getJcrom().getPath((Object)this) + "/cards");
        for (JcrCard card : jcrCards) {
            try {
                cards.add(card.getCard());
            }
            catch (Exception e) {
                LOG.error((Object)"Unexcepted error", (Throwable)e);
            }
        }
        return cards.toArray(new VCard[cards.size()]);
    }

    private JcrCardDao getCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new JcrCardDao(this.getStore().getSession(), this.getStore().getJcrom());
        }
        return this.cardDao;
    }
}

