/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdResidualProduct;
import com.axelor.apps.production.db.TempBomTree;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_BILL_OF_MATERIAL", indexes={@Index(columnList="name"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="prod_process"), @Index(columnList="company"), @Index(columnList="workshop_stock_location"), @Index(columnList="fullName"), @Index(columnList="original_bill_of_material")})
@Track(fields={@TrackField(name="name"), @TrackField(name="product"), @TrackField(name="qty"), @TrackField(name="priority"), @TrackField(name="defineSubBillOfMaterial"), @TrackField(name="unit"), @TrackField(name="prodProcess"), @TrackField(name="costPrice"), @TrackField(name="company"), @TrackField(name="hasNoManageStock"), @TrackField(name="personalized"), @TrackField(name="wasteRate"), @TrackField(name="statusSelect"), @TrackField(name="workshopStockLocation"), @TrackField(name="fullName"), @TrackField(name="versionNumber"), @TrackField(name="originalBillOfMaterial"), @TrackField(name="note")})
public class BillOfMaterial
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_BILL_OF_MATERIAL_SEQ")
    @SequenceGenerator(name="PRODUCTION_BILL_OF_MATERIAL_SEQ", sequenceName="PRODUCTION_BILL_OF_MATERIAL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    private String name;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Priority")
    private Integer priority = 0;
    @Widget(title="Define sub bill of materials")
    private Boolean defineSubBillOfMaterial = Boolean.FALSE;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Production process")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcess prodProcess;
    @Widget(title="BOMs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderBy(value="priority")
    private Set<BillOfMaterial> billOfMaterialSet;
    @Widget(title="Residual products")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ProdResidualProduct> prodResidualProductList;
    @Widget(title="Cost price")
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Not manage stock")
    private Boolean hasNoManageStock = Boolean.FALSE;
    @Widget(title="Personalized")
    private Boolean personalized = Boolean.FALSE;
    @Widget(title="Waste rate (%)")
    private BigDecimal wasteRate = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="production.bill.of.material.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Workshop")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation workshopStockLocation;
    @Widget(title="Cost sheets")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="billOfMaterial", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CostSheet> costSheetList;
    @Widget(title="Label")
    @NameColumn
    private String fullName;
    @Widget(title="Version number")
    private Integer versionNumber = 1;
    @Widget(title="Original bill of materials")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BillOfMaterial originalBillOfMaterial;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentBom", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TempBomTree> bomChildTreeList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bom", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TempBomTree> bomTreeList;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BillOfMaterial() {
    }

    public BillOfMaterial(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Boolean getDefineSubBillOfMaterial() {
        return this.defineSubBillOfMaterial == null ? Boolean.FALSE : this.defineSubBillOfMaterial;
    }

    public void setDefineSubBillOfMaterial(Boolean defineSubBillOfMaterial) {
        this.defineSubBillOfMaterial = defineSubBillOfMaterial;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public ProdProcess getProdProcess() {
        return this.prodProcess;
    }

    public void setProdProcess(ProdProcess prodProcess) {
        this.prodProcess = prodProcess;
    }

    public Set<BillOfMaterial> getBillOfMaterialSet() {
        return this.billOfMaterialSet;
    }

    public void setBillOfMaterialSet(Set<BillOfMaterial> billOfMaterialSet) {
        this.billOfMaterialSet = billOfMaterialSet;
    }

    public void addBillOfMaterialSetItem(BillOfMaterial item) {
        if (this.getBillOfMaterialSet() == null) {
            this.setBillOfMaterialSet(new HashSet<BillOfMaterial>());
        }
        this.getBillOfMaterialSet().add(item);
    }

    public void removeBillOfMaterialSetItem(BillOfMaterial item) {
        if (this.getBillOfMaterialSet() == null) {
            return;
        }
        this.getBillOfMaterialSet().remove((Object)item);
    }

    public void clearBillOfMaterialSet() {
        if (this.getBillOfMaterialSet() != null) {
            this.getBillOfMaterialSet().clear();
        }
    }

    public List<ProdResidualProduct> getProdResidualProductList() {
        return this.prodResidualProductList;
    }

    public void setProdResidualProductList(List<ProdResidualProduct> prodResidualProductList) {
        this.prodResidualProductList = prodResidualProductList;
    }

    public void addProdResidualProductListItem(ProdResidualProduct item) {
        if (this.getProdResidualProductList() == null) {
            this.setProdResidualProductList(new ArrayList<ProdResidualProduct>());
        }
        this.getProdResidualProductList().add(item);
    }

    public void removeProdResidualProductListItem(ProdResidualProduct item) {
        if (this.getProdResidualProductList() == null) {
            return;
        }
        this.getProdResidualProductList().remove((Object)item);
    }

    public void clearProdResidualProductList() {
        if (this.getProdResidualProductList() != null) {
            this.getProdResidualProductList().clear();
        }
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Boolean getHasNoManageStock() {
        return this.hasNoManageStock == null ? Boolean.FALSE : this.hasNoManageStock;
    }

    public void setHasNoManageStock(Boolean hasNoManageStock) {
        this.hasNoManageStock = hasNoManageStock;
    }

    public Boolean getPersonalized() {
        return this.personalized == null ? Boolean.FALSE : this.personalized;
    }

    public void setPersonalized(Boolean personalized) {
        this.personalized = personalized;
    }

    public BigDecimal getWasteRate() {
        return this.wasteRate == null ? BigDecimal.ZERO : this.wasteRate;
    }

    public void setWasteRate(BigDecimal wasteRate) {
        this.wasteRate = wasteRate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public StockLocation getWorkshopStockLocation() {
        return this.workshopStockLocation;
    }

    public void setWorkshopStockLocation(StockLocation workshopStockLocation) {
        this.workshopStockLocation = workshopStockLocation;
    }

    public List<CostSheet> getCostSheetList() {
        return this.costSheetList;
    }

    public void setCostSheetList(List<CostSheet> costSheetList) {
        this.costSheetList = costSheetList;
    }

    public void addCostSheetListItem(CostSheet item) {
        if (this.getCostSheetList() == null) {
            this.setCostSheetList(new ArrayList<CostSheet>());
        }
        this.getCostSheetList().add(item);
        item.setBillOfMaterial(this);
    }

    public void removeCostSheetListItem(CostSheet item) {
        if (this.getCostSheetList() == null) {
            return;
        }
        this.getCostSheetList().remove((Object)item);
    }

    public void clearCostSheetList() {
        if (this.getCostSheetList() != null) {
            this.getCostSheetList().clear();
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public BillOfMaterial getOriginalBillOfMaterial() {
        return this.originalBillOfMaterial;
    }

    public void setOriginalBillOfMaterial(BillOfMaterial originalBillOfMaterial) {
        this.originalBillOfMaterial = originalBillOfMaterial;
    }

    public List<TempBomTree> getBomChildTreeList() {
        return this.bomChildTreeList;
    }

    public void setBomChildTreeList(List<TempBomTree> bomChildTreeList) {
        this.bomChildTreeList = bomChildTreeList;
    }

    public void addBomChildTreeListItem(TempBomTree item) {
        if (this.getBomChildTreeList() == null) {
            this.setBomChildTreeList(new ArrayList<TempBomTree>());
        }
        this.getBomChildTreeList().add(item);
        item.setParentBom(this);
    }

    public void removeBomChildTreeListItem(TempBomTree item) {
        if (this.getBomChildTreeList() == null) {
            return;
        }
        this.getBomChildTreeList().remove((Object)item);
    }

    public void clearBomChildTreeList() {
        if (this.getBomChildTreeList() != null) {
            this.getBomChildTreeList().clear();
        }
    }

    public List<TempBomTree> getBomTreeList() {
        return this.bomTreeList;
    }

    public void setBomTreeList(List<TempBomTree> bomTreeList) {
        this.bomTreeList = bomTreeList;
    }

    public void addBomTreeListItem(TempBomTree item) {
        if (this.getBomTreeList() == null) {
            this.setBomTreeList(new ArrayList<TempBomTree>());
        }
        this.getBomTreeList().add(item);
        item.setBom(this);
    }

    public void removeBomTreeListItem(TempBomTree item) {
        if (this.getBomTreeList() == null) {
            return;
        }
        this.getBomTreeList().remove((Object)item);
    }

    public void clearBomTreeList() {
        if (this.getBomTreeList() != null) {
            this.getBomTreeList().clear();
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BillOfMaterial)) {
            return false;
        }
        BillOfMaterial other = (BillOfMaterial)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("qty", (Object)this.getQty()).add("priority", (Object)this.getPriority()).add("defineSubBillOfMaterial", (Object)this.getDefineSubBillOfMaterial()).add("costPrice", (Object)this.getCostPrice()).add("hasNoManageStock", (Object)this.getHasNoManageStock()).add("personalized", (Object)this.getPersonalized()).add("wasteRate", (Object)this.getWasteRate()).add("statusSelect", (Object)this.getStatusSelect()).add("fullName", (Object)this.getFullName()).add("versionNumber", (Object)this.getVersionNumber()).omitNullValues().toString();
    }
}

