/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.ConfiguratorProdProcess;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_CONFIGURATOR_BOM", indexes={@Index(columnList="company"), @Index(columnList="name"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="prod_process"), @Index(columnList="configurator_prod_process"), @Index(columnList="parent_configuratorbom")})
public class ConfiguratorBOM
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_CONFIGURATOR_BOM_SEQ")
    @SequenceGenerator(name="PRODUCTION_CONFIGURATOR_BOM_SEQ", sequenceName="PRODUCTION_CONFIGURATOR_BOM_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Label")
    private String name;
    @Widget(title="Label")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String nameFormula;
    @Widget(title="Define with a script")
    private Boolean defNameAsFormula = Boolean.FALSE;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Product")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String productFormula;
    @Widget(title="Define with a script")
    private Boolean defProductAsFormula = Boolean.FALSE;
    @Widget(title="Use generated product")
    private Boolean defProductFromConfigurator = Boolean.FALSE;
    @Widget(title="Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Qty")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String qtyFormula;
    @Widget(title="Define with a script")
    private Boolean defQtyAsFormula = Boolean.FALSE;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Unit")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String unitFormula;
    @Widget(title="Define with a script")
    private Boolean defUnitAsFormula = Boolean.FALSE;
    @Widget(title="Production process")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcess prodProcess;
    @Widget(title="Production process configurator")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ConfiguratorProdProcess configuratorProdProcess;
    @Widget(title="Production process")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String prodProcessFormula;
    @Widget(title="Define with a script")
    private Boolean defProdProcessAsFormula = Boolean.FALSE;
    @Widget(title="Define with a configurator")
    private Boolean defProdProcessAsConfigurator = Boolean.FALSE;
    @Widget(title="Configurators BOMs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentConfiguratorBOM", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ConfiguratorBOM> configuratorBomList;
    @Widget(title="Parent Configurator BOM")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ConfiguratorBOM parentConfiguratorBOM;
    @Widget(title="Define sub bill of material")
    private Boolean defineSubBillOfMaterial = Boolean.TRUE;
    @Widget(title="Status", selection="production.bill.of.material.status.select")
    private Integer statusSelect = 2;
    @Widget(title="Condition")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String useCondition;
    private Long billOfMaterialId = 0L;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ConfiguratorBOM() {
    }

    public ConfiguratorBOM(String name, String nameFormula) {
        this.name = name;
        this.nameFormula = nameFormula;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameFormula() {
        return this.nameFormula;
    }

    public void setNameFormula(String nameFormula) {
        this.nameFormula = nameFormula;
    }

    public Boolean getDefNameAsFormula() {
        return this.defNameAsFormula == null ? Boolean.FALSE : this.defNameAsFormula;
    }

    public void setDefNameAsFormula(Boolean defNameAsFormula) {
        this.defNameAsFormula = defNameAsFormula;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getProductFormula() {
        return this.productFormula;
    }

    public void setProductFormula(String productFormula) {
        this.productFormula = productFormula;
    }

    public Boolean getDefProductAsFormula() {
        return this.defProductAsFormula == null ? Boolean.FALSE : this.defProductAsFormula;
    }

    public void setDefProductAsFormula(Boolean defProductAsFormula) {
        this.defProductAsFormula = defProductAsFormula;
    }

    public Boolean getDefProductFromConfigurator() {
        return this.defProductFromConfigurator == null ? Boolean.FALSE : this.defProductFromConfigurator;
    }

    public void setDefProductFromConfigurator(Boolean defProductFromConfigurator) {
        this.defProductFromConfigurator = defProductFromConfigurator;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getQtyFormula() {
        return this.qtyFormula;
    }

    public void setQtyFormula(String qtyFormula) {
        this.qtyFormula = qtyFormula;
    }

    public Boolean getDefQtyAsFormula() {
        return this.defQtyAsFormula == null ? Boolean.FALSE : this.defQtyAsFormula;
    }

    public void setDefQtyAsFormula(Boolean defQtyAsFormula) {
        this.defQtyAsFormula = defQtyAsFormula;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getUnitFormula() {
        return this.unitFormula;
    }

    public void setUnitFormula(String unitFormula) {
        this.unitFormula = unitFormula;
    }

    public Boolean getDefUnitAsFormula() {
        return this.defUnitAsFormula == null ? Boolean.FALSE : this.defUnitAsFormula;
    }

    public void setDefUnitAsFormula(Boolean defUnitAsFormula) {
        this.defUnitAsFormula = defUnitAsFormula;
    }

    public ProdProcess getProdProcess() {
        return this.prodProcess;
    }

    public void setProdProcess(ProdProcess prodProcess) {
        this.prodProcess = prodProcess;
    }

    public ConfiguratorProdProcess getConfiguratorProdProcess() {
        return this.configuratorProdProcess;
    }

    public void setConfiguratorProdProcess(ConfiguratorProdProcess configuratorProdProcess) {
        this.configuratorProdProcess = configuratorProdProcess;
    }

    public String getProdProcessFormula() {
        return this.prodProcessFormula;
    }

    public void setProdProcessFormula(String prodProcessFormula) {
        this.prodProcessFormula = prodProcessFormula;
    }

    public Boolean getDefProdProcessAsFormula() {
        return this.defProdProcessAsFormula == null ? Boolean.FALSE : this.defProdProcessAsFormula;
    }

    public void setDefProdProcessAsFormula(Boolean defProdProcessAsFormula) {
        this.defProdProcessAsFormula = defProdProcessAsFormula;
    }

    public Boolean getDefProdProcessAsConfigurator() {
        return this.defProdProcessAsConfigurator == null ? Boolean.FALSE : this.defProdProcessAsConfigurator;
    }

    public void setDefProdProcessAsConfigurator(Boolean defProdProcessAsConfigurator) {
        this.defProdProcessAsConfigurator = defProdProcessAsConfigurator;
    }

    public List<ConfiguratorBOM> getConfiguratorBomList() {
        return this.configuratorBomList;
    }

    public void setConfiguratorBomList(List<ConfiguratorBOM> configuratorBomList) {
        this.configuratorBomList = configuratorBomList;
    }

    public void addConfiguratorBomListItem(ConfiguratorBOM item) {
        if (this.getConfiguratorBomList() == null) {
            this.setConfiguratorBomList(new ArrayList<ConfiguratorBOM>());
        }
        this.getConfiguratorBomList().add(item);
        item.setParentConfiguratorBOM(this);
    }

    public void removeConfiguratorBomListItem(ConfiguratorBOM item) {
        if (this.getConfiguratorBomList() == null) {
            return;
        }
        this.getConfiguratorBomList().remove((Object)item);
    }

    public void clearConfiguratorBomList() {
        if (this.getConfiguratorBomList() != null) {
            this.getConfiguratorBomList().clear();
        }
    }

    public ConfiguratorBOM getParentConfiguratorBOM() {
        return this.parentConfiguratorBOM;
    }

    public void setParentConfiguratorBOM(ConfiguratorBOM parentConfiguratorBOM) {
        this.parentConfiguratorBOM = parentConfiguratorBOM;
    }

    public Boolean getDefineSubBillOfMaterial() {
        return this.defineSubBillOfMaterial == null ? Boolean.FALSE : this.defineSubBillOfMaterial;
    }

    public void setDefineSubBillOfMaterial(Boolean defineSubBillOfMaterial) {
        this.defineSubBillOfMaterial = defineSubBillOfMaterial;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getUseCondition() {
        return this.useCondition;
    }

    public void setUseCondition(String useCondition) {
        this.useCondition = useCondition;
    }

    public Long getBillOfMaterialId() {
        return this.billOfMaterialId == null ? 0L : this.billOfMaterialId;
    }

    public void setBillOfMaterialId(Long billOfMaterialId) {
        this.billOfMaterialId = billOfMaterialId;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfiguratorBOM)) {
            return false;
        }
        ConfiguratorBOM other = (ConfiguratorBOM)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("defNameAsFormula", (Object)this.getDefNameAsFormula()).add("defProductAsFormula", (Object)this.getDefProductAsFormula()).add("defProductFromConfigurator", (Object)this.getDefProductFromConfigurator()).add("qty", (Object)this.getQty()).add("defQtyAsFormula", (Object)this.getDefQtyAsFormula()).add("defUnitAsFormula", (Object)this.getDefUnitAsFormula()).add("defProdProcessAsFormula", (Object)this.getDefProdProcessAsFormula()).add("defProdProcessAsConfigurator", (Object)this.getDefProdProcessAsConfigurator()).add("defineSubBillOfMaterial", (Object)this.getDefineSubBillOfMaterial()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

