/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.production.db.ConfiguratorProdProcessLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_CONFIGURATOR_PROD_PROCESS", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="code"), @Index(columnList="stock_location"), @Index(columnList="produced_product_stock_location"), @Index(columnList="workshop_stock_location")})
public class ConfiguratorProdProcess
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_CONFIGURATOR_PROD_PROCESS_SEQ")
    @SequenceGenerator(name="PRODUCTION_CONFIGURATOR_PROD_PROCESS_SEQ", sequenceName="PRODUCTION_CONFIGURATOR_PROD_PROCESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NotNull
    private String name;
    @Widget(title="Status", selection="production.bill.of.material.status.select")
    private Integer statusSelect = 2;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Phase")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="configuratorProdProcess", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ConfiguratorProdProcessLine> configuratorProdProcessLineList;
    @Widget(title="Code")
    private String code;
    @Widget(title="Code")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String codeFormula;
    @Widget(title="Define with a script")
    private Boolean defCodeAsFormula = Boolean.FALSE;
    @Widget(title="Production stock location")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Production stock location")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String stockLocationFormula;
    @Widget(title="Define with a script")
    private Boolean defStockLocationAsFormula = Boolean.FALSE;
    @Widget(title="Stock location for produced product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation producedProductStockLocation;
    @Widget(title="Stock location for produced product")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String producedProductStockLocationFormula;
    @Widget(title="Define with a script")
    private Boolean defProducedProductStockLocationAsFormula = Boolean.FALSE;
    @Widget(title="Workshop")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation workshopStockLocation;
    @Widget(title="Workshop")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String workshopStockLocationFormula;
    @Widget(title="Define with a script")
    private Boolean defWorkshopStockLocationAsFormula = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ConfiguratorProdProcess() {
    }

    public ConfiguratorProdProcess(String name, String code, String codeFormula) {
        this.name = name;
        this.code = code;
        this.codeFormula = codeFormula;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public List<ConfiguratorProdProcessLine> getConfiguratorProdProcessLineList() {
        return this.configuratorProdProcessLineList;
    }

    public void setConfiguratorProdProcessLineList(List<ConfiguratorProdProcessLine> configuratorProdProcessLineList) {
        this.configuratorProdProcessLineList = configuratorProdProcessLineList;
    }

    public void addConfiguratorProdProcessLineListItem(ConfiguratorProdProcessLine item) {
        if (this.getConfiguratorProdProcessLineList() == null) {
            this.setConfiguratorProdProcessLineList(new ArrayList<ConfiguratorProdProcessLine>());
        }
        this.getConfiguratorProdProcessLineList().add(item);
        item.setConfiguratorProdProcess(this);
    }

    public void removeConfiguratorProdProcessLineListItem(ConfiguratorProdProcessLine item) {
        if (this.getConfiguratorProdProcessLineList() == null) {
            return;
        }
        this.getConfiguratorProdProcessLineList().remove((Object)item);
    }

    public void clearConfiguratorProdProcessLineList() {
        if (this.getConfiguratorProdProcessLineList() != null) {
            this.getConfiguratorProdProcessLineList().clear();
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeFormula() {
        return this.codeFormula;
    }

    public void setCodeFormula(String codeFormula) {
        this.codeFormula = codeFormula;
    }

    public Boolean getDefCodeAsFormula() {
        return this.defCodeAsFormula == null ? Boolean.FALSE : this.defCodeAsFormula;
    }

    public void setDefCodeAsFormula(Boolean defCodeAsFormula) {
        this.defCodeAsFormula = defCodeAsFormula;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public String getStockLocationFormula() {
        return this.stockLocationFormula;
    }

    public void setStockLocationFormula(String stockLocationFormula) {
        this.stockLocationFormula = stockLocationFormula;
    }

    public Boolean getDefStockLocationAsFormula() {
        return this.defStockLocationAsFormula == null ? Boolean.FALSE : this.defStockLocationAsFormula;
    }

    public void setDefStockLocationAsFormula(Boolean defStockLocationAsFormula) {
        this.defStockLocationAsFormula = defStockLocationAsFormula;
    }

    public StockLocation getProducedProductStockLocation() {
        return this.producedProductStockLocation;
    }

    public void setProducedProductStockLocation(StockLocation producedProductStockLocation) {
        this.producedProductStockLocation = producedProductStockLocation;
    }

    public String getProducedProductStockLocationFormula() {
        return this.producedProductStockLocationFormula;
    }

    public void setProducedProductStockLocationFormula(String producedProductStockLocationFormula) {
        this.producedProductStockLocationFormula = producedProductStockLocationFormula;
    }

    public Boolean getDefProducedProductStockLocationAsFormula() {
        return this.defProducedProductStockLocationAsFormula == null ? Boolean.FALSE : this.defProducedProductStockLocationAsFormula;
    }

    public void setDefProducedProductStockLocationAsFormula(Boolean defProducedProductStockLocationAsFormula) {
        this.defProducedProductStockLocationAsFormula = defProducedProductStockLocationAsFormula;
    }

    public StockLocation getWorkshopStockLocation() {
        return this.workshopStockLocation;
    }

    public void setWorkshopStockLocation(StockLocation workshopStockLocation) {
        this.workshopStockLocation = workshopStockLocation;
    }

    public String getWorkshopStockLocationFormula() {
        return this.workshopStockLocationFormula;
    }

    public void setWorkshopStockLocationFormula(String workshopStockLocationFormula) {
        this.workshopStockLocationFormula = workshopStockLocationFormula;
    }

    public Boolean getDefWorkshopStockLocationAsFormula() {
        return this.defWorkshopStockLocationAsFormula == null ? Boolean.FALSE : this.defWorkshopStockLocationAsFormula;
    }

    public void setDefWorkshopStockLocationAsFormula(Boolean defWorkshopStockLocationAsFormula) {
        this.defWorkshopStockLocationAsFormula = defWorkshopStockLocationAsFormula;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfiguratorProdProcess)) {
            return false;
        }
        ConfiguratorProdProcess other = (ConfiguratorProdProcess)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("code", (Object)this.getCode()).add("defCodeAsFormula", (Object)this.getDefCodeAsFormula()).add("defStockLocationAsFormula", (Object)this.getDefStockLocationAsFormula()).add("defProducedProductStockLocationAsFormula", (Object)this.getDefProducedProductStockLocationAsFormula()).add("defWorkshopStockLocationAsFormula", (Object)this.getDefWorkshopStockLocationAsFormula()).omitNullValues().toString();
    }
}

