/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.production.db.ConfiguratorProdProcess;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_CONFIGURATOR_PROD_PROCESS_LINE", indexes={@Index(columnList="configurator_prod_process"), @Index(columnList="name"), @Index(columnList="work_center"), @Index(columnList="stock_location")})
public class ConfiguratorProdProcessLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_CONFIGURATOR_PROD_PROCESS_LINE_SEQ")
    @SequenceGenerator(name="PRODUCTION_CONFIGURATOR_PROD_PROCESS_LINE_SEQ", sequenceName="PRODUCTION_CONFIGURATOR_PROD_PROCESS_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Production process")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ConfiguratorProdProcess configuratorProdProcess;
    @Widget(title="Label")
    private String name;
    @Widget(title="Priority")
    private Integer priority = 0;
    @Widget(title="Work center")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter workCenter;
    @Widget(title="Outsourcing")
    private Boolean outsourcing = Boolean.FALSE;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Min. capacity / cycle")
    private BigDecimal minCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Min. capacity / cycle")
    private String minCapacityPerCycleFormula;
    @Widget(title="Define with a script")
    private Boolean defMinCapacityFormula = Boolean.FALSE;
    @Widget(title="Max. capacity / cycle")
    private BigDecimal maxCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Max. capacity / cycle")
    private String maxCapacityPerCycleFormula;
    @Widget(title="Define with a script")
    private Boolean defMaxCapacityFormula = Boolean.FALSE;
    @Widget(title="Duration / cycle (hh:mm)")
    private Long durationPerCycle = 0L;
    @Widget(title="Duration / cycle (hh:mm)")
    private String durationPerCycleFormula;
    @Widget(title="Define with a script")
    private Boolean defDurationFormula = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ConfiguratorProdProcessLine() {
    }

    public ConfiguratorProdProcessLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ConfiguratorProdProcess getConfiguratorProdProcess() {
        return this.configuratorProdProcess;
    }

    public void setConfiguratorProdProcess(ConfiguratorProdProcess configuratorProdProcess) {
        this.configuratorProdProcess = configuratorProdProcess;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public WorkCenter getWorkCenter() {
        return this.workCenter;
    }

    public void setWorkCenter(WorkCenter workCenter) {
        this.workCenter = workCenter;
    }

    public Boolean getOutsourcing() {
        return this.outsourcing == null ? Boolean.FALSE : this.outsourcing;
    }

    public void setOutsourcing(Boolean outsourcing) {
        this.outsourcing = outsourcing;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getMinCapacityPerCycle() {
        return this.minCapacityPerCycle == null ? BigDecimal.ZERO : this.minCapacityPerCycle;
    }

    public void setMinCapacityPerCycle(BigDecimal minCapacityPerCycle) {
        this.minCapacityPerCycle = minCapacityPerCycle;
    }

    public String getMinCapacityPerCycleFormula() {
        return this.minCapacityPerCycleFormula;
    }

    public void setMinCapacityPerCycleFormula(String minCapacityPerCycleFormula) {
        this.minCapacityPerCycleFormula = minCapacityPerCycleFormula;
    }

    public Boolean getDefMinCapacityFormula() {
        return this.defMinCapacityFormula == null ? Boolean.FALSE : this.defMinCapacityFormula;
    }

    public void setDefMinCapacityFormula(Boolean defMinCapacityFormula) {
        this.defMinCapacityFormula = defMinCapacityFormula;
    }

    public BigDecimal getMaxCapacityPerCycle() {
        return this.maxCapacityPerCycle == null ? BigDecimal.ZERO : this.maxCapacityPerCycle;
    }

    public void setMaxCapacityPerCycle(BigDecimal maxCapacityPerCycle) {
        this.maxCapacityPerCycle = maxCapacityPerCycle;
    }

    public String getMaxCapacityPerCycleFormula() {
        return this.maxCapacityPerCycleFormula;
    }

    public void setMaxCapacityPerCycleFormula(String maxCapacityPerCycleFormula) {
        this.maxCapacityPerCycleFormula = maxCapacityPerCycleFormula;
    }

    public Boolean getDefMaxCapacityFormula() {
        return this.defMaxCapacityFormula == null ? Boolean.FALSE : this.defMaxCapacityFormula;
    }

    public void setDefMaxCapacityFormula(Boolean defMaxCapacityFormula) {
        this.defMaxCapacityFormula = defMaxCapacityFormula;
    }

    public Long getDurationPerCycle() {
        return this.durationPerCycle == null ? 0L : this.durationPerCycle;
    }

    public void setDurationPerCycle(Long durationPerCycle) {
        this.durationPerCycle = durationPerCycle;
    }

    public String getDurationPerCycleFormula() {
        return this.durationPerCycleFormula;
    }

    public void setDurationPerCycleFormula(String durationPerCycleFormula) {
        this.durationPerCycleFormula = durationPerCycleFormula;
    }

    public Boolean getDefDurationFormula() {
        return this.defDurationFormula == null ? Boolean.FALSE : this.defDurationFormula;
    }

    public void setDefDurationFormula(Boolean defDurationFormula) {
        this.defDurationFormula = defDurationFormula;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfiguratorProdProcessLine)) {
            return false;
        }
        ConfiguratorProdProcessLine other = (ConfiguratorProdProcessLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("priority", (Object)this.getPriority()).add("outsourcing", (Object)this.getOutsourcing()).add("minCapacityPerCycle", (Object)this.getMinCapacityPerCycle()).add("minCapacityPerCycleFormula", (Object)this.getMinCapacityPerCycleFormula()).add("defMinCapacityFormula", (Object)this.getDefMinCapacityFormula()).add("maxCapacityPerCycle", (Object)this.getMaxCapacityPerCycle()).add("maxCapacityPerCycleFormula", (Object)this.getMaxCapacityPerCycleFormula()).add("defMaxCapacityFormula", (Object)this.getDefMaxCapacityFormula()).add("durationPerCycle", (Object)this.getDurationPerCycle()).add("durationPerCycleFormula", (Object)this.getDurationPerCycleFormula()).omitNullValues().toString();
    }
}

