/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.production.db.MachineType;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_MACHINE", indexes={@Index(columnList="name"), @Index(columnList="stock_location"), @Index(columnList="machine_type"), @Index(columnList="weekly_planning")})
public class Machine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_MACHINE_SEQ")
    @SequenceGenerator(name="PRODUCTION_MACHINE_SEQ", sequenceName="PRODUCTION_MACHINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Image")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Serial Nbr")
    private String serialNumber;
    @Widget(title="Brand")
    private String brand;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Machine Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MachineType machineType;
    @Widget(title="Starting duration (hh:mm:ss)")
    private Long startingDuration = 0L;
    @Widget(title="Duration between two cycles (hh:mm:ss)")
    private Long setupDuration = 0L;
    @Widget(title="Ending duration (hh:mm:ss)")
    private Long endingDuration = 0L;
    @Widget(title="Machine's planning")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlanning;
    @Widget(title="Operating duration")
    private Long operatingDuration = 0L;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Machine() {
    }

    public Machine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public MachineType getMachineType() {
        return this.machineType;
    }

    public void setMachineType(MachineType machineType) {
        this.machineType = machineType;
    }

    public Long getStartingDuration() {
        return this.startingDuration == null ? 0L : this.startingDuration;
    }

    public void setStartingDuration(Long startingDuration) {
        this.startingDuration = startingDuration;
    }

    public Long getSetupDuration() {
        return this.setupDuration == null ? 0L : this.setupDuration;
    }

    public void setSetupDuration(Long setupDuration) {
        this.setupDuration = setupDuration;
    }

    public Long getEndingDuration() {
        return this.endingDuration == null ? 0L : this.endingDuration;
    }

    public void setEndingDuration(Long endingDuration) {
        this.endingDuration = endingDuration;
    }

    public WeeklyPlanning getWeeklyPlanning() {
        return this.weeklyPlanning;
    }

    public void setWeeklyPlanning(WeeklyPlanning weeklyPlanning) {
        this.weeklyPlanning = weeklyPlanning;
    }

    public Long getOperatingDuration() {
        return this.operatingDuration == null ? 0L : this.operatingDuration;
    }

    public void setOperatingDuration(Long operatingDuration) {
        this.operatingDuration = operatingDuration;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Machine)) {
            return false;
        }
        Machine other = (Machine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("serialNumber", (Object)this.getSerialNumber()).add("brand", (Object)this.getBrand()).add("startingDuration", (Object)this.getStartingDuration()).add("setupDuration", (Object)this.getSetupDuration()).add("endingDuration", (Object)this.getEndingDuration()).add("operatingDuration", (Object)this.getOperatingDuration()).omitNullValues().toString();
    }
}

