/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.production.db.ObjectDescription;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_PROD_PROCESS_LINE", indexes={@Index(columnList="prod_process"), @Index(columnList="work_center"), @Index(columnList="name"), @Index(columnList="stock_location")})
@Track(fields={@TrackField(name="prodProcess"), @TrackField(name="workCenter"), @TrackField(name="name"), @TrackField(name="priority"), @TrackField(name="description"), @TrackField(name="minCapacityPerCycle"), @TrackField(name="maxCapacityPerCycle"), @TrackField(name="durationPerCycle"), @TrackField(name="outsourcing"), @TrackField(name="optional"), @TrackField(name="stockLocation")})
public class ProdProcessLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PROD_PROCESS_LINE_SEQ")
    @SequenceGenerator(name="PRODUCTION_PROD_PROCESS_LINE_SEQ", sequenceName="PRODUCTION_PROD_PROCESS_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Production process")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcess prodProcess;
    @Widget(title="Work center")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter workCenter;
    @Widget(title="Label")
    private String name;
    @Widget(title="Priority")
    private Integer priority = 0;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Min. capacity / cycle")
    private BigDecimal minCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Max. capacity / cycle")
    private BigDecimal maxCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Duration / cycle (hh:mm:ss)")
    private Long durationPerCycle = 0L;
    @Widget(title="Outsourcing")
    private Boolean outsourcing = Boolean.FALSE;
    @Widget(title="Optional")
    private Boolean optional = Boolean.FALSE;
    @Widget(title="Stock location")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Products to consume")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="toConsumeProdProcessLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> toConsumeProdProductList;
    @Widget(title="Descriptions")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="prodProcessLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ObjectDescription> objectDescriptionList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProdProcessLine() {
    }

    public ProdProcessLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProdProcess getProdProcess() {
        return this.prodProcess;
    }

    public void setProdProcess(ProdProcess prodProcess) {
        this.prodProcess = prodProcess;
    }

    public WorkCenter getWorkCenter() {
        return this.workCenter;
    }

    public void setWorkCenter(WorkCenter workCenter) {
        this.workCenter = workCenter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getMinCapacityPerCycle() {
        return this.minCapacityPerCycle == null ? BigDecimal.ZERO : this.minCapacityPerCycle;
    }

    public void setMinCapacityPerCycle(BigDecimal minCapacityPerCycle) {
        this.minCapacityPerCycle = minCapacityPerCycle;
    }

    public BigDecimal getMaxCapacityPerCycle() {
        return this.maxCapacityPerCycle == null ? BigDecimal.ZERO : this.maxCapacityPerCycle;
    }

    public void setMaxCapacityPerCycle(BigDecimal maxCapacityPerCycle) {
        this.maxCapacityPerCycle = maxCapacityPerCycle;
    }

    public Long getDurationPerCycle() {
        return this.durationPerCycle == null ? 0L : this.durationPerCycle;
    }

    public void setDurationPerCycle(Long durationPerCycle) {
        this.durationPerCycle = durationPerCycle;
    }

    public Boolean getOutsourcing() {
        return this.outsourcing == null ? Boolean.FALSE : this.outsourcing;
    }

    public void setOutsourcing(Boolean outsourcing) {
        this.outsourcing = outsourcing;
    }

    public Boolean getOptional() {
        return this.optional == null ? Boolean.FALSE : this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public List<ProdProduct> getToConsumeProdProductList() {
        return this.toConsumeProdProductList;
    }

    public void setToConsumeProdProductList(List<ProdProduct> toConsumeProdProductList) {
        this.toConsumeProdProductList = toConsumeProdProductList;
    }

    public void addToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            this.setToConsumeProdProductList(new ArrayList<ProdProduct>());
        }
        this.getToConsumeProdProductList().add(item);
        item.setToConsumeProdProcessLine(this);
    }

    public void removeToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            return;
        }
        this.getToConsumeProdProductList().remove((Object)item);
    }

    public void clearToConsumeProdProductList() {
        if (this.getToConsumeProdProductList() != null) {
            this.getToConsumeProdProductList().clear();
        }
    }

    public List<ObjectDescription> getObjectDescriptionList() {
        return this.objectDescriptionList;
    }

    public void setObjectDescriptionList(List<ObjectDescription> objectDescriptionList) {
        this.objectDescriptionList = objectDescriptionList;
    }

    public void addObjectDescriptionListItem(ObjectDescription item) {
        if (this.getObjectDescriptionList() == null) {
            this.setObjectDescriptionList(new ArrayList<ObjectDescription>());
        }
        this.getObjectDescriptionList().add(item);
        item.setProdProcessLine(this);
    }

    public void removeObjectDescriptionListItem(ObjectDescription item) {
        if (this.getObjectDescriptionList() == null) {
            return;
        }
        this.getObjectDescriptionList().remove((Object)item);
    }

    public void clearObjectDescriptionList() {
        if (this.getObjectDescriptionList() != null) {
            this.getObjectDescriptionList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProdProcessLine)) {
            return false;
        }
        ProdProcessLine other = (ProdProcessLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("priority", (Object)this.getPriority()).add("minCapacityPerCycle", (Object)this.getMinCapacityPerCycle()).add("maxCapacityPerCycle", (Object)this.getMaxCapacityPerCycle()).add("durationPerCycle", (Object)this.getDurationPerCycle()).add("outsourcing", (Object)this.getOutsourcing()).add("optional", (Object)this.getOptional()).omitNullValues().toString();
    }
}

