/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="PRODUCTION_PRODUCT_APPROVAL")
public class ProductApproval
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PRODUCT_APPROVAL_SEQ")
    @SequenceGenerator(name="PRODUCTION_PRODUCT_APPROVAL_SEQ", sequenceName="PRODUCTION_PRODUCT_APPROVAL_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @HashKey
    @Widget(title="name")
    @NameColumn
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Control on receipt")
    private Boolean controlOnReceipt = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductApproval() {
    }

    public ProductApproval(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getControlOnReceipt() {
        return this.controlOnReceipt == null ? Boolean.FALSE : this.controlOnReceipt;
    }

    public void setControlOnReceipt(Boolean controlOnReceipt) {
        this.controlOnReceipt = controlOnReceipt;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductApproval)) {
            return false;
        }
        ProductApproval other = (ProductApproval)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getCode(), other.getCode())) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(335015986, this.getCode(), this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("controlOnReceipt", (Object)this.getControlOnReceipt()).omitNullValues().toString();
    }
}

