/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_RAW_MATERIAL_REQUIREMENT", indexes={@Index(columnList="code"), @Index(columnList="name"), @Index(columnList="company")})
public class RawMaterialRequirement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_RAW_MATERIAL_REQUIREMENT_SEQ")
    @SequenceGenerator(name="PRODUCTION_RAW_MATERIAL_REQUIREMENT_SEQ", sequenceName="PRODUCTION_RAW_MATERIAL_REQUIREMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    @NameColumn
    private String code;
    @Widget(title="Name")
    private String name;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Duration (days)")
    @Min(value=0L)
    private Integer duration = 0;
    @Widget(title="Production stock locations")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<StockLocation> stockLocationSet;
    @Widget(title="Show all requirements ?")
    private Boolean showAllRequirements = Boolean.FALSE;
    @Widget(title="Show requirements by MO")
    private Boolean showRequirementsByMO = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public RawMaterialRequirement() {
    }

    public RawMaterialRequirement(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getDuration() {
        return this.duration == null ? 0 : this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Set<StockLocation> getStockLocationSet() {
        return this.stockLocationSet;
    }

    public void setStockLocationSet(Set<StockLocation> stockLocationSet) {
        this.stockLocationSet = stockLocationSet;
    }

    public void addStockLocationSetItem(StockLocation item) {
        if (this.getStockLocationSet() == null) {
            this.setStockLocationSet(new HashSet<StockLocation>());
        }
        this.getStockLocationSet().add(item);
    }

    public void removeStockLocationSetItem(StockLocation item) {
        if (this.getStockLocationSet() == null) {
            return;
        }
        this.getStockLocationSet().remove((Object)item);
    }

    public void clearStockLocationSet() {
        if (this.getStockLocationSet() != null) {
            this.getStockLocationSet().clear();
        }
    }

    public Boolean getShowAllRequirements() {
        return this.showAllRequirements == null ? Boolean.FALSE : this.showAllRequirements;
    }

    public void setShowAllRequirements(Boolean showAllRequirements) {
        this.showAllRequirements = showAllRequirements;
    }

    public Boolean getShowRequirementsByMO() {
        return this.showRequirementsByMO == null ? Boolean.FALSE : this.showRequirementsByMO;
    }

    public void setShowRequirementsByMO(Boolean showRequirementsByMO) {
        this.showRequirementsByMO = showRequirementsByMO;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RawMaterialRequirement)) {
            return false;
        }
        RawMaterialRequirement other = (RawMaterialRequirement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("duration", (Object)this.getDuration()).add("showAllRequirements", (Object)this.getShowAllRequirements()).add("showRequirementsByMO", (Object)this.getShowRequirementsByMO()).omitNullValues().toString();
    }
}

