/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_UNIT_COST_CALC_LINE", indexes={@Index(columnList="unit_cost_calculation"), @Index(columnList="product"), @Index(columnList="company"), @Index(columnList="cost_sheet")})
public class UnitCostCalcLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_UNIT_COST_CALC_LINE_SEQ")
    @SequenceGenerator(name="PRODUCTION_UNIT_COST_CALC_LINE_SEQ", sequenceName="PRODUCTION_UNIT_COST_CALC_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Cost price calculation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private UnitCostCalculation unitCostCalculation;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Previous cost")
    @Digits(integer=10, fraction=10)
    private BigDecimal previousCost = BigDecimal.ZERO;
    @Widget(title="Comput. cost")
    @Digits(integer=10, fraction=10)
    private BigDecimal computedCost = BigDecimal.ZERO;
    @Widget(title="Cost to apply")
    @Digits(integer=10, fraction=10)
    private BigDecimal costToApply = BigDecimal.ZERO;
    @Widget(title="Maximum level")
    private Integer maxLevel = 0;
    @Widget(title="Cost sheet")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheet costSheet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UnitCostCalculation getUnitCostCalculation() {
        return this.unitCostCalculation;
    }

    public void setUnitCostCalculation(UnitCostCalculation unitCostCalculation) {
        this.unitCostCalculation = unitCostCalculation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getPreviousCost() {
        return this.previousCost == null ? BigDecimal.ZERO : this.previousCost;
    }

    public void setPreviousCost(BigDecimal previousCost) {
        this.previousCost = previousCost;
    }

    public BigDecimal getComputedCost() {
        return this.computedCost == null ? BigDecimal.ZERO : this.computedCost;
    }

    public void setComputedCost(BigDecimal computedCost) {
        this.computedCost = computedCost;
    }

    public BigDecimal getCostToApply() {
        return this.costToApply == null ? BigDecimal.ZERO : this.costToApply;
    }

    public void setCostToApply(BigDecimal costToApply) {
        this.costToApply = costToApply;
    }

    public Integer getMaxLevel() {
        return this.maxLevel == null ? 0 : this.maxLevel;
    }

    public void setMaxLevel(Integer maxLevel) {
        this.maxLevel = maxLevel;
    }

    public CostSheet getCostSheet() {
        return this.costSheet;
    }

    public void setCostSheet(CostSheet costSheet) {
        this.costSheet = costSheet;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnitCostCalcLine)) {
            return false;
        }
        UnitCostCalcLine other = (UnitCostCalcLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("previousCost", (Object)this.getPreviousCost()).add("computedCost", (Object)this.getComputedCost()).add("costToApply", (Object)this.getCostToApply()).add("maxLevel", (Object)this.getMaxLevel()).omitNullValues().toString();
    }
}

