/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.TempBomTree;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public interface BillOfMaterialService {
    public static final String UNIT_MIN_CODE = "MIN";
    public static final String UNIT_DAY_CODE = "JR";

    public List<BillOfMaterial> getBillOfMaterialSet(Product var1);

    @Transactional(rollbackOn={Exception.class})
    public void updateProductCostPrice(BillOfMaterial var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(SaleOrderLine var1) throws AxelorException;

    public BillOfMaterial generateNewVersion(BillOfMaterial var1);

    public String getFileName(BillOfMaterial var1);

    public String getReportLink(BillOfMaterial var1, String var2, String var3, String var4) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public TempBomTree generateTree(BillOfMaterial var1);

    @Transactional
    public void setBillOfMaterialAsDefault(BillOfMaterial var1);

    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(BillOfMaterial var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(BillOfMaterial var1, int var2) throws AxelorException;

    public String computeName(BillOfMaterial var1);

    public void addRawMaterials(long var1, ArrayList<LinkedHashMap<String, Object>> var3) throws AxelorException;
}

