/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.sale.db.repo.SaleOrderLineRepository;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.supplychain.db.Mrp;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.db.MrpLineOrigin;
import com.axelor.apps.supplychain.db.MrpLineType;
import com.axelor.apps.supplychain.db.repo.MrpForecastRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineRepository;
import com.axelor.apps.supplychain.db.repo.MrpLineTypeRepository;
import com.axelor.apps.supplychain.db.repo.MrpRepository;
import com.axelor.apps.supplychain.service.MrpLineService;
import com.axelor.apps.supplychain.service.MrpServiceImpl;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrpServiceProductionImpl
extends MrpServiceImpl {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected ManufOrderRepository manufOrderRepository;
    protected ProductCompanyService productCompanyService;

    @Inject
    public MrpServiceProductionImpl(AppBaseService appBaseService, AppProductionService appProductionService, MrpRepository mrpRepository, StockLocationRepository stockLocationRepository, ProductRepository productRepository, StockLocationLineRepository stockLocationLineRepository, MrpLineTypeRepository mrpLineTypeRepository, PurchaseOrderLineRepository purchaseOrderLineRepository, SaleOrderLineRepository saleOrderLineRepository, MrpLineRepository mrpLineRepository, StockRulesService stockRulesService, MrpLineService mrpLineService, MrpForecastRepository mrpForecastRepository, ManufOrderRepository manufOrderRepository, StockLocationService stockLocationService, ProductCompanyService productCompanyService) {
        super((AppBaseService)appProductionService, mrpRepository, stockLocationRepository, productRepository, stockLocationLineRepository, mrpLineTypeRepository, purchaseOrderLineRepository, saleOrderLineRepository, mrpLineRepository, stockRulesService, mrpLineService, mrpForecastRepository, stockLocationService);
        this.appBaseService = appBaseService;
        this.manufOrderRepository = manufOrderRepository;
        this.productCompanyService = productCompanyService;
    }

    protected void completeMrp(Mrp mrp) throws AxelorException {
        super.completeMrp(mrp);
        if (((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            this.createManufOrderMrpLines();
        }
    }

    protected void createManufOrderMrpLines() throws AxelorException {
        MrpLineType manufOrderMrpLineType = this.getMrpLineType(6);
        MrpLineType manufOrderNeedMrpLineType = this.getMrpLineType(7);
        String statusSelect = manufOrderMrpLineType.getStatusSelect();
        List statusList = StringTool.getIntegerList((String)statusSelect);
        if (statusList.isEmpty()) {
            statusList.add(6);
        }
        List manufOrderList = this.manufOrderRepository.all().filter("self.product.id in (?1) AND self.prodProcess.stockLocation in (?2) AND self.statusSelect IN (?3)", new Object[]{this.productMap.keySet(), this.stockLocationList, statusList}).fetch();
        for (ManufOrder manufOrder : manufOrderList) {
            this.createManufOrderMrpLines((Mrp)this.mrpRepository.find(this.mrp.getId()), (ManufOrder)((Object)this.manufOrderRepository.find(manufOrder.getId())), (MrpLineType)this.mrpLineTypeRepository.find(manufOrderMrpLineType.getId()), (MrpLineType)this.mrpLineTypeRepository.find(manufOrderNeedMrpLineType.getId()));
            JPA.clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createManufOrderMrpLines(Mrp mrp, ManufOrder manufOrder, MrpLineType manufOrderMrpLineType, MrpLineType manufOrderNeedMrpLineType) throws AxelorException {
        MrpLine mrpLine;
        Object product;
        StockLocation stockLocation = manufOrder.getProdProcess().getStockLocation();
        LocalDate maturityDate = null;
        maturityDate = manufOrder.getPlannedEndDateT() != null ? manufOrder.getPlannedEndDateT().toLocalDate() : manufOrder.getPlannedStartDateT().toLocalDate();
        maturityDate = this.computeMaturityDate(maturityDate, manufOrderMrpLineType);
        for (ProdProduct prodProduct : manufOrder.getToProduceProdProductList()) {
            product = prodProduct.getProduct();
            if (!this.isBeforeEndDate(maturityDate) && !manufOrderMrpLineType.getIgnoreEndDate().booleanValue() || !this.isMrpProduct((Product)((Object)product)) || (mrpLine = this.createMrpLine(mrp, (Product)((Object)product), manufOrderMrpLineType, prodProduct.getQty(), maturityDate, BigDecimal.ZERO, stockLocation, (Model)((Object)manufOrder))) == null) continue;
            this.mrpLineRepository.save((Model)mrpLine);
        }
        if (manufOrder.getIsConsProOnOperation().booleanValue()) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                for (ProdProduct prodProduct : operationOrder.getToConsumeProdProductList()) {
                    Product product2 = prodProduct.getProduct();
                    if (!this.isMrpProduct(product2)) continue;
                    maturityDate = null;
                    maturityDate = operationOrder.getPlannedEndDateT() != null ? operationOrder.getPlannedEndDateT().toLocalDate() : operationOrder.getPlannedStartDateT().toLocalDate();
                    maturityDate = this.computeMaturityDate(maturityDate, manufOrderNeedMrpLineType);
                    MrpLine mrpLine2 = this.createMrpLine(mrp, prodProduct.getProduct(), manufOrderNeedMrpLineType, prodProduct.getQty(), maturityDate, BigDecimal.ZERO, stockLocation, (Model)((Object)operationOrder));
                    if (mrpLine2 == null) continue;
                    this.mrpLineRepository.save((Model)mrpLine2);
                }
            }
        } else {
            for (ProdProduct prodProduct : manufOrder.getToConsumeProdProductList()) {
                product = prodProduct.getProduct();
                if (!this.isMrpProduct((Product)((Object)product))) continue;
                if (!this.productMap.containsKey(product.getId())) {
                    this.assignProductAndLevel((Product)((Object)product), manufOrder.getProduct());
                    this.createAvailableStockMrpLine((Product)((Object)product), manufOrder.getProdProcess().getStockLocation());
                }
                if ((mrpLine = this.createMrpLine(mrp, (Product)((Object)product), manufOrderNeedMrpLineType, prodProduct.getQty(), maturityDate, BigDecimal.ZERO, stockLocation, (Model)((Object)manufOrder))) == null) continue;
                this.mrpLineRepository.save((Model)mrpLine);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void createProposalMrpLine(Mrp mrp, Product product, MrpLineType mrpLineType, BigDecimal reorderQty, StockLocation stockLocation, LocalDate maturityDate, List<MrpLineOrigin> mrpLineOriginList, String relatedToSelectName) throws AxelorException {
        super.createProposalMrpLine(mrp, product, mrpLineType, reorderQty, stockLocation, maturityDate, mrpLineOriginList, relatedToSelectName);
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return;
        }
        BillOfMaterial defaultBillOfMaterial = product.getDefaultBillOfMaterial();
        if (mrpLineType.getElementSelect() == 8 && defaultBillOfMaterial != null) {
            MrpLineType manufProposalNeedMrpLineType = this.getMrpLineType(9);
            for (BillOfMaterial billOfMaterial : defaultBillOfMaterial.getBillOfMaterialSet()) {
                Product subProduct = billOfMaterial.getProduct();
                if (!this.isMrpProduct(subProduct)) continue;
                super.createProposalMrpLine(mrp, subProduct, manufProposalNeedMrpLineType, reorderQty.multiply(billOfMaterial.getQty()).setScale(this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN), stockLocation, maturityDate, mrpLineOriginList, relatedToSelectName);
            }
        }
    }

    protected MrpLineType getMrpLineTypeForProposal(StockRules stockRules, Product product, Company company) throws AxelorException {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return super.getMrpLineTypeForProposal(stockRules, product, company);
        }
        if (stockRules != null) {
            if (stockRules.getOrderAlertSelect() == 3) {
                return this.getMrpLineType(8);
            }
            return this.getMrpLineType(5);
        }
        if ("buy".equals((String)this.productCompanyService.get(product, "procurementMethodSelect", company))) {
            return this.getMrpLineType(5);
        }
        return this.getMrpLineType(8);
    }

    protected boolean isProposalElement(MrpLineType mrpLineType) {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return super.isProposalElement(mrpLineType);
        }
        return mrpLineType.getElementSelect() == 5 || mrpLineType.getElementSelect() == 8 || mrpLineType.getElementSelect() == 9;
    }

    protected void assignProductAndLevel(Product product) throws AxelorException {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            super.assignProductAndLevel(product);
            return;
        }
        this.log.debug("Add of the product : {}", (Object)product.getFullName());
        this.productMap.put(product.getId(), this.getMaxLevel(product, 0));
        if (product.getDefaultBillOfMaterial() != null) {
            this.assignProductLevel(product.getDefaultBillOfMaterial(), 0);
        }
    }

    public int getMaxLevel(Product product, int level) {
        if (this.productMap.containsKey(product.getId())) {
            return Math.max(level, (Integer)this.productMap.get(product.getId()));
        }
        return level;
    }

    protected void assignProductLevel(BillOfMaterial billOfMaterial, int level) throws AxelorException {
        if (level > 100) {
            if (billOfMaterial == null || billOfMaterial.getProduct() == null) {
                throw new AxelorException(4, I18n.get((String)"Configuration issue: the MRP execution was canceled because a loop was detected when searching for components in BOM."));
            }
            throw new AxelorException(4, I18n.get((String)"Configuration issue in product %s: the MRP execution was canceled because a loop was detected when searching for components in BOM."), new Object[]{billOfMaterial.getProduct().getFullName()});
        }
        if (billOfMaterial.getBillOfMaterialSet() == null || billOfMaterial.getBillOfMaterialSet().isEmpty()) {
            Product subProduct = billOfMaterial.getProduct();
            this.log.debug("Add of the sub product : {} for the level : {} ", (Object)subProduct.getFullName(), (Object)level);
            this.productMap.put(subProduct.getId(), this.getMaxLevel(subProduct, level));
        } else {
            ++level;
            for (BillOfMaterial subBillOfMaterial : billOfMaterial.getBillOfMaterialSet()) {
                Product subProduct = subBillOfMaterial.getProduct();
                if (!this.isMrpProduct(subProduct)) continue;
                this.assignProductLevel(subBillOfMaterial, level);
                if (subProduct.getDefaultBillOfMaterial() == null) continue;
                this.assignProductLevel(subProduct.getDefaultBillOfMaterial(), level);
            }
        }
    }

    protected void assignProductAndLevel(Product manufOrderComponentProduct, Product manufOrderProducedProduct) {
        this.log.debug("Add of the product : {}", (Object)manufOrderComponentProduct.getFullName());
        this.productMap.put(manufOrderComponentProduct.getId(), this.getMaxLevel(manufOrderProducedProduct, 0) + 1);
    }

    protected void createAvailableStockMrpLine(Product product, StockLocation stockLocation) throws AxelorException {
        MrpLineType availableStockMrpLineType = this.getMrpLineType(1);
        this.mrpLineRepository.save((Model)this.createAvailableStockMrpLine((Mrp)this.mrpRepository.find(this.mrp.getId()), (Product)((Object)this.productRepository.find(product.getId())), stockLocation, availableStockMrpLineType));
    }

    protected Mrp completeProjectedStock(Mrp mrp, Product product, Company company, StockLocation stockLocation) throws AxelorException {
        super.completeProjectedStock(mrp, product, company, stockLocation);
        this.createManufOrderMrpLines();
        return mrp;
    }
}

