/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderSaleOrderService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.supplychain.service.AccountingSituationSupplychainService;
import com.axelor.apps.supplychain.service.SaleOrderPurchaseService;
import com.axelor.apps.supplychain.service.SaleOrderStockService;
import com.axelor.apps.supplychain.service.SaleOrderWorkflowServiceSupplychainImpl;
import com.axelor.apps.supplychain.service.app.AppSupplychainService;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class SaleOrderWorkflowServiceProductionImpl
extends SaleOrderWorkflowServiceSupplychainImpl {
    protected ProductionOrderSaleOrderService productionOrderSaleOrderService;
    protected AppProductionService appProductionService;

    @Inject
    public SaleOrderWorkflowServiceProductionImpl(SequenceService sequenceService, PartnerRepository partnerRepo, SaleOrderRepository saleOrderRepo, AppSaleService appSaleService, UserService userService, SaleOrderStockService saleOrderStockService, SaleOrderPurchaseService saleOrderPurchaseService, AppSupplychainService appSupplychainService, AccountingSituationSupplychainService accountingSituationSupplychainService, ProductionOrderSaleOrderService productionOrderSaleOrderService, AppProductionService appProductionService) {
        super(sequenceService, partnerRepo, saleOrderRepo, appSaleService, userService, saleOrderStockService, saleOrderPurchaseService, appSupplychainService, accountingSituationSupplychainService);
        this.productionOrderSaleOrderService = productionOrderSaleOrderService;
        this.appProductionService = appProductionService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void confirmSaleOrder(SaleOrder saleOrder) throws AxelorException {
        super.confirmSaleOrder(saleOrder);
        if (this.appProductionService.isApp("production") && this.appProductionService.getAppProduction().getProductionOrderGenerationAuto().booleanValue()) {
            this.productionOrderSaleOrderService.generateProductionOrder(saleOrder);
        }
    }
}

