/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.db.repo.TemplateRepository;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockConfigRepository;
import com.axelor.apps.stock.db.repo.StockRulesRepository;
import com.axelor.apps.supplychain.service.StockRulesServiceSupplychainImpl;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public class StockRulesServiceProductionImpl
extends StockRulesServiceSupplychainImpl {
    @Inject
    public StockRulesServiceProductionImpl(StockRulesRepository stockRuleRepo, PurchaseOrderLineService purchaseOrderLineService, PurchaseOrderRepository purchaseOrderRepo, TemplateRepository templateRepo, TemplateMessageService templateMessageService, MessageRepository messageRepo, StockConfigRepository stockConfigRepo) {
        super(stockRuleRepo, purchaseOrderLineService, purchaseOrderRepo, templateRepo, templateMessageService, messageRepo, stockConfigRepo);
    }

    public void generateOrder(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type) throws AxelorException {
        StockLocation stockLocation = stockLocationLine.getStockLocation();
        if (stockLocation == null) {
            return;
        }
        StockRules stockRules = this.getStockRules(product, stockLocation, type, 2);
        if (stockRules == null) {
            return;
        }
        if (stockRules.getOrderAlertSelect().equals(3)) {
            this.generateProductionOrder(product, qty, stockLocationLine, type, stockRules);
        } else {
            this.generatePurchaseOrder(product, qty, stockLocationLine, type);
        }
    }

    public void generateProductionOrder(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type, StockRules stockRules) throws AxelorException {
        if (this.useMinStockRules(stockLocationLine, this.getStockRules(product, stockLocationLine.getStockLocation(), type, 2), qty, type)) {
            BigDecimal qtyToProduce = this.getQtyToOrder(qty, stockLocationLine, type, stockRules);
            ((ProductionOrderService)Beans.get(ProductionOrderService.class)).generateProductionOrder(product, null, qtyToProduce, LocalDateTime.now());
            if (stockRules.getAlert().booleanValue()) {
                this.generateAndSendMessage(stockRules);
            }
        }
    }
}

