/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.app;

import com.axelor.apps.base.db.AppProduction;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseServiceImpl;
import com.axelor.apps.production.db.ProductionConfig;
import com.axelor.apps.production.db.repo.ProductionConfigRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.inject.Beans;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;

@Singleton
public class AppProductionServiceImpl
extends AppBaseServiceImpl
implements AppProductionService {
    public static final int DEFAULT_NB_DECIMAL_DIGITS = 2;

    @Override
    public AppProduction getAppProduction() {
        return (AppProduction)((Object)Query.of(AppProduction.class).cacheable().fetchOne());
    }

    @Override
    @Transactional
    public void generateProductionConfigurations() {
        List companies = Query.of(Company.class).filter("self.productionConfig is null").fetch();
        for (Company company : companies) {
            ProductionConfig productionConfig = new ProductionConfig();
            productionConfig.setCompany(company);
            ((ProductionConfigRepository)((Object)Beans.get(ProductionConfigRepository.class))).save((Model)((Object)productionConfig));
        }
    }

    @Override
    public int getNbDecimalDigitForBomQty() {
        AppProduction appProduction = this.getAppProduction();
        if (appProduction != null) {
            return appProduction.getNbDecimalDigitForBomQty();
        }
        return 2;
    }
}

