/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.app;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ConfiguratorBOM;
import com.axelor.apps.production.service.configurator.ConfiguratorBomService;
import com.axelor.apps.sale.db.Configurator;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.service.configurator.ConfiguratorServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.JsonContext;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class ConfiguratorServiceProductionImpl
extends ConfiguratorServiceImpl {
    @Inject
    public ConfiguratorServiceProductionImpl(AppBaseService appBaseService) {
        super(appBaseService);
    }

    @Transactional(rollbackOn={Exception.class})
    public void generate(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        super.generate(configurator, jsonAttributes, jsonIndicators);
        ConfiguratorBOM configuratorBOM = configurator.getConfiguratorCreator().getConfiguratorBom();
        if (configuratorBOM != null) {
            Product generatedProduct = configurator.getProduct();
            ((ConfiguratorBomService)Beans.get(ConfiguratorBomService.class)).generateBillOfMaterial(configuratorBOM, jsonAttributes, 0, generatedProduct).ifPresent(generatedProduct::setDefaultBillOfMaterial);
        }
    }

    protected SaleOrderLine generateSaleOrderLine(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators, SaleOrder saleOrder) throws AxelorException {
        SaleOrderLine saleOrderLine = super.generateSaleOrderLine(configurator, jsonAttributes, jsonIndicators, saleOrder);
        ConfiguratorBOM configuratorBOM = configurator.getConfiguratorCreator().getConfiguratorBom();
        if (configuratorBOM != null) {
            ((ConfiguratorBomService)Beans.get(ConfiguratorBomService.class)).generateBillOfMaterial(configuratorBOM, jsonAttributes, 0, null).ifPresent(saleOrderLine::setBillOfMaterial);
        }
        return saleOrderLine;
    }
}

