/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.ProductionBatch;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

public class BatchComputeWorkInProgressValuation
extends AbstractBatch {
    protected CostSheetService costSheetService;
    protected ManufOrderRepository manufOrderRepository;
    protected static final int FETCH_LIMIT = 1;

    @Inject
    public BatchComputeWorkInProgressValuation(CostSheetService costSheetService, ManufOrderRepository manufOrderRepository) {
        this.costSheetService = costSheetService;
        this.manufOrderRepository = manufOrderRepository;
    }

    protected void process() {
        List manufOrderList;
        ProductionBatch productionBatch = this.batch.getProductionBatch();
        Company company = productionBatch.getCompany();
        StockLocation workshopStockLocation = productionBatch.getWorkshopStockLocation();
        if (productionBatch.getValuationDate() == null) {
            productionBatch.setValuationDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company));
        }
        LocalDate valuationDate = productionBatch.getValuationDate();
        HashMap<String, Comparable<Integer>> bindValues = new HashMap<String, Comparable<Integer>>();
        String domain = "(self.statusSelect = :statusSelectInProgress or self.statusSelect = :statusSelectStandBy or (self.statusSelect = :statusSelectFinished AND self.realEndDateT BETWEEN :valuationDateT AND :todayDateT))";
        bindValues.put("statusSelectInProgress", Integer.valueOf(4));
        bindValues.put("statusSelectStandBy", Integer.valueOf(5));
        bindValues.put("statusSelectFinished", Integer.valueOf(6));
        bindValues.put("valuationDateT", valuationDate.atStartOfDay());
        bindValues.put("todayDateT", this.appBaseService.getTodayDateTime().toLocalDateTime());
        if (company != null) {
            domain = domain + " and self.company.id = :companyId";
            bindValues.put("companyId", company.getId());
        }
        if (workshopStockLocation != null) {
            domain = domain + " and self.workshopStockLocation.id = :stockLocationId";
            bindValues.put("stockLocationId", workshopStockLocation.getId());
        }
        Query manufOrderQuery = ((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter(domain).bind(bindValues);
        int offset = 0;
        while (!(manufOrderList = manufOrderQuery.order("id").fetch(1, offset)).isEmpty()) {
            for (ManufOrder manufOrder : manufOrderList) {
                ++offset;
                try {
                    this.costSheetService.computeCostPrice(manufOrder, 3, valuationDate);
                    this.incrementDone();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)e, (String)"costSheet", (long)this.batch.getId());
                }
            }
            JPA.clear();
        }
    }

    protected void stop() {
        String comment = String.format("\t* %s " + I18n.get((String)"Computed work in progress valuation") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }
}

