/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.config;

import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;

public class StockConfigProductionService
extends StockConfigService {
    public StockLocation getProductionVirtualStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getProductionVirtualStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a production virtual stock location for company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getProductionVirtualStockLocation();
    }

    public StockLocation getWasteStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getWasteStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a waste stock location for company %s."), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getWasteStockLocation();
    }

    public StockLocation getFinishedProductsDefaultStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getFinishedProductsDefaultStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a finished products default stock location for company %s."), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getFinishedProductsDefaultStockLocation();
    }

    public StockLocation getComponentDefaultStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getComponentDefaultStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a component default stock location for company %s."), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getComponentDefaultStockLocation();
    }
}

