/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.configurator;

import com.axelor.apps.production.db.ConfiguratorBOM;
import com.axelor.apps.production.db.ConfiguratorProdProcess;
import com.axelor.apps.production.db.ConfiguratorProdProcessLine;
import com.axelor.apps.production.db.repo.ConfiguratorBOMRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.sale.db.ConfiguratorCreator;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorImportServiceImpl;
import com.axelor.apps.sale.service.configurator.ConfiguratorCreatorService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConfiguratorCreatorImportServiceProductionImpl
extends ConfiguratorCreatorImportServiceImpl {
    private static int MAX_DEPTH = 50;

    @Inject
    public ConfiguratorCreatorImportServiceProductionImpl(ConfiguratorCreatorService configuratorCreatorService) {
        super(configuratorCreatorService);
    }

    protected void updateAttributeNameInFormulas(ConfiguratorCreator creator, String oldName, String newName) throws AxelorException {
        super.updateAttributeNameInFormulas(creator, oldName, newName);
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return;
        }
        ConfiguratorBOM configuratorBom = creator.getConfiguratorBom();
        if (configuratorBom != null) {
            this.updateAttributeNameInFormulas(configuratorBom, oldName, newName, 0);
        }
    }

    protected void updateAttributeNameInFormulas(ConfiguratorBOM configuratorBom, String oldName, String newName, int counter) throws AxelorException {
        List childConfiguratorBomList;
        if (counter > MAX_DEPTH) {
            throw new AxelorException(5, I18n.get((String)"Too many recursive calls to import the bill of material configurator."));
        }
        this.updateAllFormulaFields((Object)configuratorBom, oldName, newName);
        ConfiguratorProdProcess configuratorProdProcess = configuratorBom.getConfiguratorProdProcess();
        if (configuratorProdProcess != null) {
            this.updateAttributeNameInFormulas(configuratorBom.getConfiguratorProdProcess(), oldName, newName);
        }
        if ((childConfiguratorBomList = ((ConfiguratorBOMRepository)((Object)Beans.get(ConfiguratorBOMRepository.class))).all().filter("self.parentConfiguratorBOM.id = :parentId").bind("parentId", (Object)configuratorBom.getId()).fetch()) != null) {
            for (ConfiguratorBOM childConfiguratorBom : childConfiguratorBomList) {
                this.updateAttributeNameInFormulas(childConfiguratorBom, oldName, newName, counter + 1);
            }
        }
    }

    protected void updateAttributeNameInFormulas(ConfiguratorProdProcess configuratorProdProcess, String oldName, String newName) throws AxelorException {
        List<ConfiguratorProdProcessLine> configuratorProdProcessLines = configuratorProdProcess.getConfiguratorProdProcessLineList();
        if (configuratorProdProcessLines == null) {
            return;
        }
        for (ConfiguratorProdProcessLine configuratorProdProcessLine : configuratorProdProcessLines) {
            this.updateAllFormulaFields((Object)configuratorProdProcessLine, oldName, newName);
        }
    }

    protected void updateAllFormulaFields(Object obj, String oldName, String newName) throws AxelorException {
        List formulaFields = Arrays.stream(obj.getClass().getDeclaredFields()).filter(field -> field.getType().equals(String.class)).collect(Collectors.toList());
        for (Field field2 : formulaFields) {
            try {
                Object strFormula = new PropertyDescriptor(field2.getName(), obj.getClass()).getReadMethod().invoke(obj, new Object[0]);
                if (strFormula == null) continue;
                new PropertyDescriptor(field2.getName(), obj.getClass()).getWriteMethod().invoke(obj, ((String)strFormula).replace(oldName, newName));
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new AxelorException((Throwable)e, 5);
            }
        }
    }
}

