/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.configurator;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.ConfiguratorProdProcess;
import com.axelor.apps.production.db.ConfiguratorProdProcessLine;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.repo.ProdProcessRepository;
import com.axelor.apps.production.service.configurator.ConfiguratorProdProcessLineService;
import com.axelor.apps.production.service.configurator.ConfiguratorProdProcessService;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.rpc.JsonContext;
import com.google.inject.Inject;
import java.util.List;

public class ConfiguratorProdProcessServiceImpl
implements ConfiguratorProdProcessService {
    protected ConfiguratorProdProcessLineService confProdProcessLineService;
    protected ConfiguratorService configuratorService;
    protected ProdProcessRepository prodProcessRepository;

    @Inject
    ConfiguratorProdProcessServiceImpl(ConfiguratorProdProcessLineService confProdProcessLineService, ConfiguratorService configuratorService, ProdProcessRepository prodProcessRepository) {
        this.confProdProcessLineService = confProdProcessLineService;
        this.configuratorService = configuratorService;
        this.prodProcessRepository = prodProcessRepository;
    }

    @Override
    public ProdProcess generateProdProcessService(ConfiguratorProdProcess confProdProcess, JsonContext attributes, Product product) throws AxelorException {
        if (confProdProcess == null) {
            return null;
        }
        String code = confProdProcess.getDefCodeAsFormula() != false ? String.valueOf(this.configuratorService.computeFormula(confProdProcess.getCodeFormula(), attributes)) : confProdProcess.getCode();
        StockLocation stockLocation = confProdProcess.getDefStockLocationAsFormula() != false ? (StockLocation)((Object)this.configuratorService.computeFormula(confProdProcess.getStockLocationFormula(), attributes)) : confProdProcess.getStockLocation();
        StockLocation producedProductStockLocation = confProdProcess.getDefProducedProductStockLocationAsFormula() != false ? (StockLocation)((Object)this.configuratorService.computeFormula(confProdProcess.getProducedProductStockLocationFormula(), attributes)) : confProdProcess.getProducedProductStockLocation();
        StockLocation workshopStockLocation = confProdProcess.getDefWorkshopStockLocationAsFormula() != false ? (StockLocation)((Object)this.configuratorService.computeFormula(confProdProcess.getWorkshopStockLocationFormula(), attributes)) : confProdProcess.getWorkshopStockLocation();
        ProdProcess prodProcess = this.createProdProcessHeader(confProdProcess, code, stockLocation, producedProductStockLocation, workshopStockLocation, product);
        List<ConfiguratorProdProcessLine> confLines = confProdProcess.getConfiguratorProdProcessLineList();
        if (confLines != null) {
            for (ConfiguratorProdProcessLine confLine : confLines) {
                prodProcess.addProdProcessLineListItem(this.confProdProcessLineService.generateProdProcessLine(confLine, attributes));
            }
        }
        return prodProcess;
    }

    protected ProdProcess createProdProcessHeader(ConfiguratorProdProcess confProdProcess, String code, StockLocation stockLocation, StockLocation producedProductStockLocation, StockLocation workshopStockLocation, Product product) {
        ProdProcess prodProcess = new ProdProcess();
        prodProcess.setName(confProdProcess.getName());
        prodProcess.setCompany(confProdProcess.getCompany());
        prodProcess.setStatusSelect(confProdProcess.getStatusSelect());
        prodProcess.setCode(code);
        prodProcess.setStockLocation(stockLocation);
        prodProcess.setProducedProductStockLocation(producedProductStockLocation);
        prodProcess.setWorkshopStockLocation(workshopStockLocation);
        prodProcess.setProduct(product);
        return (ProdProcess)((Object)this.prodProcessRepository.save((Model)((Object)prodProcess)));
    }
}

