/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.costsheet;

import com.axelor.apps.base.db.AppProduction;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.CostSheetLine;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.ProdResidualProduct;
import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.CostSheetLineService;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostSheetServiceImpl
implements CostSheetService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected UnitConversionService unitConversionService;
    protected CostSheetLineService costSheetLineService;
    protected BillOfMaterialRepository billOfMaterialRepo;
    protected AppBaseService appBaseService;
    protected AppProductionService appProductionService;
    protected Unit hourUnit;
    protected Unit cycleUnit;
    protected boolean manageResidualProductOnBom;
    protected CostSheet costSheet;

    @Inject
    public CostSheetServiceImpl(AppProductionService appProductionService, UnitConversionService unitConversionService, CostSheetLineService costSheetLineService, AppBaseService appBaseService, BillOfMaterialRepository billOfMaterialRepo) {
        this.appProductionService = appProductionService;
        this.unitConversionService = unitConversionService;
        this.costSheetLineService = costSheetLineService;
        this.appBaseService = appBaseService;
        this.billOfMaterialRepo = billOfMaterialRepo;
    }

    protected void init() {
        AppProduction appProduction = this.appProductionService.getAppProduction();
        this.hourUnit = this.appProductionService.getAppBase().getUnitHours();
        this.cycleUnit = appProduction.getCycleUnit();
        this.manageResidualProductOnBom = appProduction.getManageResidualProductOnBom();
        this.costSheet = new CostSheet();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public CostSheet computeCostPrice(BillOfMaterial billOfMaterial, int origin, UnitCostCalculation unitCostCalculation) throws AxelorException {
        this.init();
        billOfMaterial.addCostSheetListItem(this.costSheet);
        CostSheetLine producedCostSheetLine = this.costSheetLineService.createProducedProductCostSheetLine(billOfMaterial.getProduct(), billOfMaterial.getUnit(), billOfMaterial.getQty());
        this.costSheet.addCostSheetLineListItem(producedCostSheetLine);
        this.costSheet.setCalculationTypeSelect(4);
        this.costSheet.setCalculationDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(billOfMaterial.getCompany()));
        Company company = billOfMaterial.getCompany();
        if (company != null && company.getCurrency() != null) {
            this.costSheet.setCurrency(company.getCurrency());
        }
        this._computeCostPrice(billOfMaterial.getCompany(), billOfMaterial, 0, producedCostSheetLine, origin, unitCostCalculation);
        this.computeResidualProduct(billOfMaterial);
        billOfMaterial.setCostPrice(this.computeCostPrice(this.costSheet));
        this.billOfMaterialRepo.save((Model)((Object)billOfMaterial));
        return this.costSheet;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public CostSheet computeCostPrice(ManufOrder manufOrder, int calculationTypeSelect, LocalDate calculationDate) throws AxelorException {
        this.init();
        List<CostSheet> costSheetList = manufOrder.getCostSheetList();
        LocalDate previousCostSheetDate = null;
        for (CostSheet costSheet : costSheetList) {
            if (costSheet.getCalculationTypeSelect() != 2 && costSheet.getCalculationTypeSelect() != 1 || costSheet.getCalculationDate() == null) continue;
            if (previousCostSheetDate == null) {
                previousCostSheetDate = costSheet.getCalculationDate();
                continue;
            }
            if (!costSheet.getCalculationDate().isAfter(previousCostSheetDate)) continue;
            previousCostSheetDate = costSheet.getCalculationDate();
        }
        manufOrder.addCostSheetListItem(this.costSheet);
        this.costSheet.setCalculationTypeSelect(calculationTypeSelect);
        this.costSheet.setCalculationDate(calculationDate != null ? calculationDate : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(manufOrder.getCompany()));
        BigDecimal producedQty = this.computeTotalProducedQty(manufOrder.getProduct(), manufOrder.getProducedStockMoveLineList(), this.costSheet.getCalculationDate(), previousCostSheetDate, this.costSheet.getCalculationTypeSelect());
        CostSheetLine producedCostSheetLine = this.costSheetLineService.createProducedProductCostSheetLine(manufOrder.getProduct(), manufOrder.getUnit(), producedQty);
        this.costSheet.addCostSheetLineListItem(producedCostSheetLine);
        Company company = manufOrder.getCompany();
        if (company != null && company.getCurrency() != null) {
            this.costSheet.setCurrency(company.getCurrency());
        }
        BigDecimal totalToProduceQty = this.getTotalToProduceQty(manufOrder);
        BigDecimal ratio = BigDecimal.ZERO;
        if (totalToProduceQty.compareTo(BigDecimal.ZERO) != 0) {
            ratio = producedQty.divide(totalToProduceQty, 5, RoundingMode.HALF_UP);
        }
        this.costSheet.setManufOrderProducedRatio(ratio);
        this.computeRealCostPrice(manufOrder, 0, producedCostSheetLine, previousCostSheetDate);
        this.computeRealResidualProduct(manufOrder);
        this.computeCostPrice(this.costSheet);
        manufOrder.setCostPrice(this.costSheet.getCostPrice());
        ((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).save((Model)((Object)manufOrder));
        return this.costSheet;
    }

    protected void computeResidualProduct(BillOfMaterial billOfMaterial) throws AxelorException {
        if (this.manageResidualProductOnBom && billOfMaterial.getProdResidualProductList() != null) {
            for (ProdResidualProduct prodResidualProduct : billOfMaterial.getProdResidualProductList()) {
                CostSheetLine costSheetLine = this.costSheetLineService.createResidualProductCostSheetLine(prodResidualProduct.getProduct(), prodResidualProduct.getUnit(), prodResidualProduct.getQty(), billOfMaterial.getCompany());
                this.costSheet.addCostSheetLineListItem(costSheetLine);
            }
        }
    }

    protected BigDecimal computeCostPrice(CostSheet costSheet) {
        BigDecimal costPrice = BigDecimal.ZERO;
        if (costSheet.getCostSheetLineList() != null) {
            for (CostSheetLine costSheetLine : costSheet.getCostSheetLineList()) {
                if (costSheetLine.getCostSheetLineList() != null && !costSheetLine.getCostSheetLineList().isEmpty()) {
                    costPrice = costPrice.add(this.computeCostPrice(costSheetLine));
                    continue;
                }
                costPrice = costPrice.add(costSheetLine.getCostPrice());
            }
        }
        costSheet.setCostPrice(costPrice);
        return costPrice;
    }

    protected BigDecimal computeCostPrice(CostSheetLine parentCostSheetLine) {
        BigDecimal costPrice = BigDecimal.ZERO;
        if (parentCostSheetLine.getCostSheetLineList() != null) {
            for (CostSheetLine costSheetLine : parentCostSheetLine.getCostSheetLineList()) {
                if (costSheetLine.getCostSheetLineList() != null && !costSheetLine.getCostSheetLineList().isEmpty()) {
                    costPrice = costPrice.add(this.computeCostPrice(costSheetLine));
                    continue;
                }
                costPrice = costPrice.add(costSheetLine.getCostPrice());
            }
        }
        parentCostSheetLine.setCostPrice(costPrice);
        return costPrice;
    }

    protected void _computeCostPrice(Company company, BillOfMaterial billOfMaterial, int bomLevel, CostSheetLine parentCostSheetLine, int origin, UnitCostCalculation unitCostCalculation) throws AxelorException {
        this._computeToConsumeProduct(company, billOfMaterial, ++bomLevel, parentCostSheetLine, origin, unitCostCalculation);
        this._computeProcess(billOfMaterial.getProdProcess(), billOfMaterial.getQty(), billOfMaterial.getProduct().getUnit(), bomLevel, parentCostSheetLine);
    }

    protected void _computeToConsumeProduct(Company company, BillOfMaterial billOfMaterial, int bomLevel, CostSheetLine parentCostSheetLine, int origin, UnitCostCalculation unitCostCalculation) throws AxelorException {
        if (billOfMaterial.getBillOfMaterialSet() != null) {
            for (BillOfMaterial billOfMaterialLine : billOfMaterial.getBillOfMaterialSet()) {
                Product product = billOfMaterialLine.getProduct();
                if (product == null) continue;
                CostSheetLine costSheetLine = this.costSheetLineService.createConsumedProductCostSheetLine(company, product, billOfMaterialLine.getUnit(), bomLevel, parentCostSheetLine, billOfMaterialLine.getQty(), origin, unitCostCalculation);
                BigDecimal wasteRate = billOfMaterialLine.getWasteRate();
                if (wasteRate != null && wasteRate.compareTo(BigDecimal.ZERO) > 0) {
                    this.costSheetLineService.createConsumedProductWasteCostSheetLine(company, product, billOfMaterialLine.getUnit(), bomLevel, parentCostSheetLine, billOfMaterialLine.getQty(), wasteRate, origin, unitCostCalculation);
                }
                if (!billOfMaterialLine.getDefineSubBillOfMaterial().booleanValue()) continue;
                this._computeCostPrice(company, billOfMaterialLine, bomLevel, costSheetLine, origin, unitCostCalculation);
            }
        }
    }

    protected void _computeProcess(ProdProcess prodProcess, BigDecimal producedQty, Unit pieceUnit, int bomLevel, CostSheetLine parentCostSheetLine) throws AxelorException {
        if (prodProcess != null && prodProcess.getProdProcessLineList() != null) {
            for (ProdProcessLine prodProcessLine : prodProcess.getProdProcessLineList()) {
                WorkCenter workCenter = prodProcessLine.getWorkCenter();
                if (workCenter == null) continue;
                int workCenterTypeSelect = workCenter.getWorkCenterTypeSelect();
                if (workCenterTypeSelect == 1 || workCenterTypeSelect == 3) {
                    this._computeHumanResourceCost(workCenter, (int)prodProcessLine.getPriority(), bomLevel, parentCostSheetLine);
                }
                if (workCenterTypeSelect != 2 && workCenterTypeSelect != 3) continue;
                this._computeMachineCost(prodProcessLine, producedQty, pieceUnit, bomLevel, parentCostSheetLine);
            }
        }
    }

    protected void _computeHumanResourceCost(WorkCenter workCenter, int priority, int bomLevel, CostSheetLine parentCostSheetLine) throws AxelorException {
        if (workCenter.getProdHumanResourceList() != null) {
            for (ProdHumanResource prodHumanResource : workCenter.getProdHumanResourceList()) {
                this._computeHumanResourceCost(prodHumanResource, priority, bomLevel, parentCostSheetLine);
            }
        }
    }

    protected void _computeHumanResourceCost(ProdHumanResource prodHumanResource, int priority, int bomLevel, CostSheetLine parentCostSheetLine) throws AxelorException {
        BigDecimal costPerHour = BigDecimal.ZERO;
        if (prodHumanResource.getProduct() != null) {
            Product product = prodHumanResource.getProduct();
            costPerHour = this.unitConversionService.convert(this.hourUnit, product.getUnit(), product.getCostPrice(), this.appProductionService.getNbDecimalDigitForUnitPrice(), product);
        }
        BigDecimal durationHours = BigDecimal.valueOf(prodHumanResource.getDuration()).divide(BigDecimal.valueOf(3600L), this.appProductionService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_EVEN);
        this.costSheetLineService.createWorkCenterHRCostSheetLine(prodHumanResource.getWorkCenter(), prodHumanResource, priority, bomLevel, parentCostSheetLine, durationHours, costPerHour.multiply(durationHours), this.hourUnit);
    }

    protected void _computeMachineCost(ProdProcessLine prodProcessLine, BigDecimal producedQty, Unit pieceUnit, int bomLevel, CostSheetLine parentCostSheetLine) {
        WorkCenter workCenter = prodProcessLine.getWorkCenter();
        int costType = workCenter.getCostTypeSelect();
        if (costType == 2) {
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, prodProcessLine.getPriority(), bomLevel, parentCostSheetLine, this.getNbCycle(producedQty, prodProcessLine.getMaxCapacityPerCycle()), workCenter.getCostAmount(), this.cycleUnit);
        } else if (costType == 1) {
            BigDecimal qty = new BigDecimal(prodProcessLine.getDurationPerCycle()).divide(new BigDecimal(3600), this.appProductionService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP).multiply(this.getNbCycle(producedQty, prodProcessLine.getMaxCapacityPerCycle()));
            BigDecimal costPrice = workCenter.getCostAmount().multiply(qty);
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, prodProcessLine.getPriority(), bomLevel, parentCostSheetLine, qty, costPrice, this.hourUnit);
        } else if (costType == 3) {
            BigDecimal costPrice = workCenter.getCostAmount().multiply(producedQty);
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, prodProcessLine.getPriority(), bomLevel, parentCostSheetLine, producedQty, costPrice, pieceUnit);
        }
    }

    protected BigDecimal getNbCycle(BigDecimal producedQty, BigDecimal capacityPerCycle) {
        if (capacityPerCycle.compareTo(BigDecimal.ZERO) == 0) {
            return producedQty;
        }
        return producedQty.divide(capacityPerCycle, RoundingMode.CEILING);
    }

    protected void computeRealResidualProduct(ManufOrder manufOrder) throws AxelorException {
        for (StockMoveLine stockMoveLine : manufOrder.getProducedStockMoveLineList()) {
            if (stockMoveLine.getProduct() == null || manufOrder.getProduct() == null || stockMoveLine.getProduct().equals((Object)manufOrder.getProduct())) continue;
            CostSheetLine costSheetLine = this.costSheetLineService.createResidualProductCostSheetLine(stockMoveLine.getProduct(), stockMoveLine.getUnit(), stockMoveLine.getRealQty(), manufOrder.getCompany());
            this.costSheet.addCostSheetLineListItem(costSheetLine);
        }
    }

    protected void computeRealCostPrice(ManufOrder manufOrder, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) throws AxelorException {
        this.computeConsumedProduct(manufOrder, ++bomLevel, parentCostSheetLine, previousCostSheetDate);
        BigDecimal producedQty = parentCostSheetLine.getConsumptionQty();
        this.computeRealProcess(manufOrder.getOperationOrderList(), manufOrder.getProduct().getUnit(), producedQty, bomLevel, parentCostSheetLine, previousCostSheetDate);
    }

    protected void computeConsumedProduct(ManufOrder manufOrder, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) throws AxelorException {
        BigDecimal ratio = this.costSheet.getManufOrderProducedRatio();
        if (manufOrder.getIsConsProOnOperation().booleanValue()) {
            for (OperationOrder operation : manufOrder.getOperationOrderList()) {
                this.computeConsumedProduct(bomLevel, previousCostSheetDate, parentCostSheetLine, operation.getConsumedStockMoveLineList(), operation.getToConsumeProdProductList(), ratio);
            }
        } else {
            this.computeConsumedProduct(bomLevel, previousCostSheetDate, parentCostSheetLine, manufOrder.getConsumedStockMoveLineList(), manufOrder.getToConsumeProdProductList(), ratio);
        }
    }

    protected void computeConsumedProduct(int bomLevel, LocalDate previousCostSheetDate, CostSheetLine parentCostSheetLine, List<StockMoveLine> consumedStockMoveLineList, List<ProdProduct> toConsumeProdProductList, BigDecimal ratio) throws AxelorException {
        CostSheet parentCostSheet = parentCostSheetLine.getCostSheet();
        int calculationTypeSelect = parentCostSheet.getCalculationTypeSelect();
        LocalDate calculationDate = parentCostSheet.getCalculationDate();
        Map<List<Object>, BigDecimal> consumedStockMoveLinePerProductAndUnit = this.getTotalQtyPerProductAndUnit(consumedStockMoveLineList, calculationDate, previousCostSheetDate, calculationTypeSelect);
        for (List<Object> keys : consumedStockMoveLinePerProductAndUnit.keySet()) {
            Iterator<Object> iterator = keys.iterator();
            Product product = (Product)((Object)iterator.next());
            Unit unit = (Unit)iterator.next();
            BigDecimal realQty = consumedStockMoveLinePerProductAndUnit.get(keys);
            if (product == null) continue;
            BigDecimal valuationQty = BigDecimal.ZERO;
            if (calculationTypeSelect == 3) {
                BigDecimal plannedConsumeQty = this.computeTotalQtyPerUnit(toConsumeProdProductList, product, unit);
                valuationQty = realQty.subtract(plannedConsumeQty.multiply(ratio));
            }
            if ((valuationQty = valuationQty.setScale(this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) == 0) continue;
            this.costSheetLineService.createConsumedProductCostSheetLine(parentCostSheet.getManufOrder().getCompany(), product, unit, bomLevel, parentCostSheetLine, valuationQty, 1, null);
        }
    }

    protected BigDecimal computeTotalProducedQty(Product producedProduct, List<StockMoveLine> producedStockMoveLineList, LocalDate calculationDate, LocalDate previousCostSheetDate, int calculationTypeSelect) throws AxelorException {
        BigDecimal totalQty = BigDecimal.ZERO;
        Map<List<Object>, BigDecimal> producedStockMoveLinePerProductAndUnit = this.getTotalQtyPerProductAndUnit(producedStockMoveLineList, calculationDate, previousCostSheetDate, calculationTypeSelect);
        for (List<Object> keys : producedStockMoveLinePerProductAndUnit.keySet()) {
            Iterator<Object> iterator = keys.iterator();
            Product product = (Product)((Object)iterator.next());
            Unit unit = (Unit)iterator.next();
            BigDecimal realQty = producedStockMoveLinePerProductAndUnit.get(keys);
            if (product == null || !product.equals((Object)producedProduct)) continue;
            totalQty = totalQty.add(this.unitConversionService.convert(unit, this.costSheet.getManufOrder().getUnit(), realQty, realQty.scale(), product));
        }
        return totalQty;
    }

    protected BigDecimal computeTotalQtyPerUnit(List<ProdProduct> prodProductList, Product product, Unit unit) {
        BigDecimal totalQty = BigDecimal.ZERO;
        for (ProdProduct prodProduct : prodProductList) {
            if (!product.equals((Object)prodProduct.getProduct()) || !unit.equals((Object)prodProduct.getUnit())) continue;
            totalQty = totalQty.add(prodProduct.getQty());
        }
        return totalQty;
    }

    protected Map<List<Object>, BigDecimal> getTotalQtyPerProductAndUnit(List<StockMoveLine> stockMoveLineList, LocalDate calculationDate, LocalDate previousCostSheetDate, int calculationType) {
        HashMap<List<Object>, BigDecimal> stockMoveLinePerProductAndUnitMap = new HashMap<List<Object>, BigDecimal>();
        if (stockMoveLineList == null) {
            return stockMoveLinePerProductAndUnitMap;
        }
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            StockMove stockMove = stockMoveLine.getStockMove();
            if (stockMove == null || 3 != stockMoveLine.getStockMove().getStatusSelect() || (calculationType == 1 || calculationType == 2) && previousCostSheetDate != null && !previousCostSheetDate.isBefore(stockMove.getRealDate()) || calculationType == 3 && calculationDate.isBefore(stockMove.getRealDate())) continue;
            Product productKey = stockMoveLine.getProduct();
            Unit unitKey = stockMoveLine.getUnit();
            ArrayList<Product> keys = new ArrayList<Product>();
            keys.add(productKey);
            keys.add((Product)unitKey);
            BigDecimal qty = (BigDecimal)stockMoveLinePerProductAndUnitMap.get(keys);
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            stockMoveLinePerProductAndUnitMap.put(keys, qty.add(stockMoveLine.getRealQty()));
        }
        return stockMoveLinePerProductAndUnitMap;
    }

    protected void computeRealProcess(List<OperationOrder> operationOrders, Unit pieceUnit, BigDecimal producedQty, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) throws AxelorException {
        for (OperationOrder operationOrder : operationOrders) {
            WorkCenter workCenter = operationOrder.getMachineWorkCenter();
            if (workCenter == null) {
                workCenter = operationOrder.getWorkCenter();
            }
            if (workCenter == null) continue;
            int workCenterTypeSelect = workCenter.getWorkCenterTypeSelect();
            if (workCenterTypeSelect == 1 || workCenterTypeSelect == 3) {
                this.computeRealHumanResourceCost(operationOrder, operationOrder.getPriority(), bomLevel, parentCostSheetLine, previousCostSheetDate);
            }
            if (workCenterTypeSelect != 2 && workCenterTypeSelect != 3) continue;
            this.computeRealMachineCost(operationOrder, workCenter, producedQty, pieceUnit, bomLevel, parentCostSheetLine, previousCostSheetDate);
        }
    }

    protected void computeRealHumanResourceCost(OperationOrder operationOrder, int priority, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) throws AxelorException {
        if (operationOrder.getProdHumanResourceList() != null) {
            Long duration = 0L;
            if (parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 2 || parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 1) {
                Period period = previousCostSheetDate != null ? Period.between(parentCostSheetLine.getCostSheet().getCalculationDate(), previousCostSheetDate) : null;
                duration = period != null ? Long.valueOf(period.getDays() * 24) : operationOrder.getRealDuration();
            } else if (parentCostSheetLine.getCostSheet().getCalculationTypeSelect() == 3) {
                BigDecimal ratio = this.costSheet.getManufOrderProducedRatio();
                Long plannedDuration = DurationTool.getSecondsDuration((Duration)Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT())) * ratio.longValue();
                Long totalPlannedDuration = 0L;
                for (OperationOrder manufOperationOrder : operationOrder.getManufOrder().getOperationOrderList()) {
                    if (manufOperationOrder.getId() != operationOrder.getId()) continue;
                    totalPlannedDuration = totalPlannedDuration + manufOperationOrder.getPlannedDuration();
                }
                duration = Math.abs(totalPlannedDuration - plannedDuration);
            }
            for (ProdHumanResource prodHumanResource : operationOrder.getProdHumanResourceList()) {
                this.computeRealHumanResourceCost(prodHumanResource, operationOrder.getWorkCenter(), priority, bomLevel, parentCostSheetLine, duration);
            }
        }
    }

    protected void computeRealHumanResourceCost(ProdHumanResource prodHumanResource, WorkCenter workCenter, int priority, int bomLevel, CostSheetLine parentCostSheetLine, Long realDuration) throws AxelorException {
        BigDecimal costPerHour = BigDecimal.ZERO;
        costPerHour = workCenter.getCostAmount();
        BigDecimal durationHours = new BigDecimal(realDuration).divide(new BigDecimal(3600), this.appProductionService.getNbDecimalDigitForUnitPrice(), 6);
        this.costSheetLineService.createWorkCenterHRCostSheetLine(workCenter, prodHumanResource, priority, bomLevel, parentCostSheetLine, durationHours, costPerHour.multiply(durationHours), this.hourUnit);
    }

    protected void computeRealMachineCost(OperationOrder operationOrder, WorkCenter workCenter, BigDecimal producedQty, Unit pieceUnit, int bomLevel, CostSheetLine parentCostSheetLine, LocalDate previousCostSheetDate) {
        int costType = workCenter.getCostTypeSelect();
        if (costType == 2) {
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, operationOrder.getPriority(), bomLevel, parentCostSheetLine, this.getNbCycle(producedQty, workCenter.getMaxCapacityPerCycle()), workCenter.getCostAmount(), this.cycleUnit);
        } else if (costType == 1) {
            BigDecimal qty = BigDecimal.ZERO;
            if (workCenter.getIsRevaluationAtActualPrices().booleanValue()) {
                qty = new BigDecimal(operationOrder.getRealDuration()).divide(new BigDecimal(3600), this.appProductionService.getNbDecimalDigitForUnitPrice(), 6);
            } else {
                BigDecimal manufOrderQty = operationOrder.getManufOrder().getQty();
                BigDecimal durationPerCycle = new BigDecimal(workCenter.getDurationPerCycle()).divide(new BigDecimal(3600), this.appProductionService.getNbDecimalDigitForUnitPrice(), 6);
                if (manufOrderQty.compareTo(workCenter.getMinCapacityPerCycle()) == 1) {
                    BigDecimal maxCapacityPerCycle = workCenter.getMaxCapacityPerCycle().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : workCenter.getMaxCapacityPerCycle();
                    qty = manufOrderQty.divide(maxCapacityPerCycle, this.appProductionService.getNbDecimalDigitForUnitPrice(), 6).multiply(durationPerCycle).setScale(this.appBaseService.getNbDecimalDigitForQty(), 6);
                } else {
                    qty = durationPerCycle;
                }
            }
            BigDecimal costPrice = workCenter.getCostAmount().multiply(qty);
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, operationOrder.getPriority(), bomLevel, parentCostSheetLine, qty, costPrice, this.hourUnit);
        } else if (costType == 3) {
            BigDecimal costPrice = workCenter.getCostAmount().multiply(producedQty);
            this.costSheetLineService.createWorkCenterMachineCostSheetLine(workCenter, operationOrder.getPriority(), bomLevel, parentCostSheetLine, producedQty, costPrice, pieceUnit);
        }
    }

    protected BigDecimal getTotalToProduceQty(ManufOrder manufOrder) throws AxelorException {
        BigDecimal totalProducedQty = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : manufOrder.getProducedStockMoveLineList()) {
            if (!stockMoveLine.getUnit().equals((Object)manufOrder.getUnit()) || stockMoveLine.getStockMove().getStatusSelect() != 2 && stockMoveLine.getStockMove().getStatusSelect() != 3) continue;
            Product product = stockMoveLine.getProduct();
            totalProducedQty = totalProducedQty.add(this.unitConversionService.convert(stockMoveLine.getUnit(), this.costSheet.getManufOrder().getUnit(), stockMoveLine.getQty(), stockMoveLine.getQty().scale(), product));
        }
        return totalProducedQty;
    }
}

