/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.costsheet;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.UnitCostCalcLine;
import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.apps.production.db.repo.UnitCostCalcLineRepository;
import com.axelor.apps.production.service.costsheet.UnitCostCalcLineService;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitCostCalcLineServiceImpl
implements UnitCostCalcLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ProductRepository productRepository;
    protected UnitCostCalcLineRepository unitCostCalcLineRepository;
    protected ProductCompanyService productCompanyService;

    @Inject
    public UnitCostCalcLineServiceImpl(UnitCostCalcLineRepository unitCostCalcLineRepository, ProductCompanyService productCompanyService) {
        this.unitCostCalcLineRepository = unitCostCalcLineRepository;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public UnitCostCalcLine createUnitCostCalcLine(Product product, Company company, int maxLevel, CostSheet costSheet) throws AxelorException {
        UnitCostCalcLine unitCostCalcLine = new UnitCostCalcLine();
        unitCostCalcLine.setProduct(product);
        unitCostCalcLine.setCompany(company);
        unitCostCalcLine.setPreviousCost((BigDecimal)this.productCompanyService.get(product, "costPrice", company));
        unitCostCalcLine.setCostSheet(costSheet);
        unitCostCalcLine.setComputedCost(costSheet.getCostPrice());
        unitCostCalcLine.setCostToApply(costSheet.getCostPrice());
        unitCostCalcLine.setMaxLevel(maxLevel);
        return unitCostCalcLine;
    }

    public UnitCostCalcLine getUnitCostCalcLine(UnitCostCalculation unitCostCalculation, Product product) {
        return (UnitCostCalcLine)((Object)this.unitCostCalcLineRepository.all().filter("self.unitCostCalculation = ?1 AND self.product = ?2", new Object[]{unitCostCalculation, product}).fetchOne());
    }
}

