/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.costsheet;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.UnitCostCalcLine;
import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.apps.production.db.repo.UnitCostCalcLineRepository;
import com.axelor.apps.production.db.repo.UnitCostCalculationRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.production.service.costsheet.UnitCostCalcLineService;
import com.axelor.apps.production.service.costsheet.UnitCostCalculationService;
import com.axelor.apps.tool.StringTool;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.data.csv.CSVImporter;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.dms.db.DMSFile;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.ValidationException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitCostCalculationServiceImpl
implements UnitCostCalculationService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ProductRepository productRepository;
    protected UnitCostCalculationRepository unitCostCalculationRepository;
    protected UnitCostCalcLineService unitCostCalcLineService;
    protected CostSheetService costSheetService;
    protected UnitCostCalcLineRepository unitCostCalcLineRepository;
    protected AppProductionService appProductionService;
    protected ProductService productService;
    protected ProductCompanyService productCompanyService;
    protected Map<Long, Integer> productMap;

    @Inject
    public UnitCostCalculationServiceImpl(ProductRepository productRepository, UnitCostCalculationRepository unitCostCalculationRepository, UnitCostCalcLineService unitCostCalcLineService, CostSheetService costSheetService, UnitCostCalcLineRepository unitCostCalcLineRepository, AppProductionService appProductionService, ProductService productService, ProductCompanyService productCompanyService) {
        this.productRepository = productRepository;
        this.unitCostCalculationRepository = unitCostCalculationRepository;
        this.unitCostCalcLineService = unitCostCalcLineService;
        this.costSheetService = costSheetService;
        this.unitCostCalcLineRepository = unitCostCalcLineRepository;
        this.appProductionService = appProductionService;
        this.productService = productService;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public MetaFile exportUnitCostCalc(UnitCostCalculation unitCostCalculation, String fileName) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List<UnitCostCalcLine> unitCostCalcLineList = unitCostCalculation.getUnitCostCalcLineList();
        Collections.sort(unitCostCalcLineList, new Comparator<UnitCostCalcLine>(){

            @Override
            public int compare(UnitCostCalcLine unitCostCalcLine1, UnitCostCalcLine unitCostCalcLine2) {
                return unitCostCalcLine1.getProduct().getCode().compareTo(unitCostCalcLine2.getProduct().getCode());
            }
        });
        for (UnitCostCalcLine unitCostCalcLine : unitCostCalcLineList) {
            String[] item = new String[]{unitCostCalcLine.getProduct() == null ? "" : unitCostCalcLine.getProduct().getCode(), unitCostCalcLine.getProduct() == null ? "" : unitCostCalcLine.getProduct().getName(), unitCostCalcLine.getComputedCost().toString(), unitCostCalcLine.getCostToApply().toString()};
            list.add(item);
        }
        String filePath = AppSettings.get().get("file.upload.dir");
        Path path = Paths.get(filePath, fileName);
        File file = path.toFile();
        this.log.debug("File located at: {}", (Object)path);
        String[] headers = new String[]{I18n.get((String)"Product_code"), I18n.get((String)"Product_name"), I18n.get((String)"Product_currency"), I18n.get((String)"Computed_cost"), I18n.get((String)"Cost_to_apply")};
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (char)'\"', (String[])headers, list);
        try (FileInputStream is = new FileInputStream(file);){
            DMSFile dmsFile = ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, fileName, (Model)((Object)unitCostCalculation));
            MetaFile metaFile = dmsFile.getMetaFile();
            return metaFile;
        }
    }

    @Override
    public void importUnitCostCalc(MetaFile dataFile, UnitCostCalculation unitCostCalculation) throws IOException {
        File tempDir = Files.createTempDir();
        File csvFile = new File(tempDir, "unitcostcalc.csv");
        Files.copy((File)MetaFiles.getPath((MetaFile)dataFile).toFile(), (File)csvFile);
        File configXmlFile = this.getConfigXmlFile();
        CSVImporter csvImporter = new CSVImporter(configXmlFile.getAbsolutePath(), tempDir.getAbsolutePath());
        HashMap<String, Long> context = new HashMap<String, Long>();
        context.put("_unitCostCalculation", unitCostCalculation.getId());
        csvImporter.setContext(context);
        csvImporter.run();
    }

    protected File getConfigXmlFile() {
        File configFile = null;
        try {
            configFile = File.createTempFile("input-config", ".xml");
            InputStream bindFileInputStream = this.getClass().getResourceAsStream("/import-configs/csv-config.xml");
            if (bindFileInputStream == null) {
                throw new ValidationException("Data import failed");
            }
            FileOutputStream outputStream = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)bindFileInputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return configFile;
    }

    @Override
    public void runUnitCostCalc(UnitCostCalculation unitCostCalculation) throws AxelorException {
        if (!unitCostCalculation.getUnitCostCalcLineList().isEmpty()) {
            this.clear(unitCostCalculation);
        }
        unitCostCalculation = (UnitCostCalculation)((Object)this.unitCostCalculationRepository.find(unitCostCalculation.getId()));
        this.assignProductAndLevel(this.getProductList(unitCostCalculation));
        this.calculationProcess(unitCostCalculation);
        this.updateStatusToComputed((UnitCostCalculation)((Object)this.unitCostCalculationRepository.find(unitCostCalculation.getId())));
    }

    @Transactional
    protected void clear(UnitCostCalculation unitCostCalculation) {
        unitCostCalculation.clearUnitCostCalcLineList();
        this.unitCostCalculationRepository.save((Model)((Object)unitCostCalculation));
    }

    @Transactional
    protected void updateStatusToComputed(UnitCostCalculation unitCostCalculation) {
        unitCostCalculation.setCalculationDate(this.appProductionService.getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
        unitCostCalculation.setStatusSelect(2);
        this.unitCostCalculationRepository.save((Model)((Object)unitCostCalculation));
    }

    protected void calculationProcess(UnitCostCalculation unitCostCalculation) throws AxelorException {
        for (int level = this.getMaxLevel(); level >= 0; --level) {
            for (Product product : this.getProductList(level)) {
                this.calculationProductProcess((UnitCostCalculation)((Object)this.unitCostCalculationRepository.find(unitCostCalculation.getId())), (Product)((Object)this.productRepository.find(product.getId())));
                JPA.clear();
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void calculationProductProcess(UnitCostCalculation unitCostCalculation, Product product) throws AxelorException {
        int level = this.productMap.get(product.getId());
        this.log.debug("Unit cost price calculation for product : {}, level : {}", (Object)product.getCode(), (Object)level);
        int origin = unitCostCalculation.getAllBomLevels() != false ? 2 : 0;
        BillOfMaterial billOfMaterial = product.getDefaultBillOfMaterial();
        CostSheet costSheet = this.costSheetService.computeCostPrice(billOfMaterial, origin, unitCostCalculation);
        UnitCostCalcLine unitCostCalcLine = this.unitCostCalcLineService.createUnitCostCalcLine(product, billOfMaterial.getCompany(), level, costSheet);
        unitCostCalculation.addUnitCostCalcLineListItem(unitCostCalcLine);
        this.unitCostCalculationRepository.save((Model)((Object)unitCostCalculation));
    }

    protected Set<Product> getProductList(UnitCostCalculation unitCostCalculation) throws AxelorException {
        HashSet productSet = Sets.newHashSet();
        if (!unitCostCalculation.getProductSet().isEmpty()) {
            productSet.addAll(unitCostCalculation.getProductSet());
        }
        List productSubTypeSelects = StringTool.getIntegerList((String)unitCostCalculation.getProductSubTypeSelect());
        if (!unitCostCalculation.getProductCategorySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productCategory in (?1) AND self.productTypeSelect = ?2 AND self.productSubTypeSelect in (?3) AND self.defaultBillOfMaterial.company in (?4) AND self.procurementMethodSelect in (?5, ?6) AND self.dtype = 'Product'", new Object[]{unitCostCalculation.getProductCategorySet(), "storable", productSubTypeSelects, unitCostCalculation.getCompanySet(), "produce", "buyAndProduce"}).fetch());
        }
        if (!unitCostCalculation.getProductFamilySet().isEmpty()) {
            productSet.addAll(this.productRepository.all().filter("self.productFamily in (?1) AND self.productTypeSelect = ?2 AND self.productSubTypeSelect in (?3) AND self.defaultBillOfMaterial.company in (?4) AND self.procurementMethodSelect in (?5, ?6) AND self.dtype = 'Product'", new Object[]{unitCostCalculation.getProductFamilySet(), "storable", productSubTypeSelects, unitCostCalculation.getCompanySet(), "produce", "buyAndProduce"}).fetch());
        }
        if (productSet.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"Please select an element (a product, a product category or a product family) to run calculation"));
        }
        return productSet;
    }

    protected List<Product> getProductList(int level) {
        ArrayList productList = Lists.newArrayList();
        for (Long productId : this.productMap.keySet()) {
            if (this.productMap.get(productId) != level) continue;
            productList.add(this.productRepository.find(productId));
        }
        return productList;
    }

    protected void assignProductAndLevel(Set<Product> productList) {
        this.productMap = Maps.newHashMap();
        for (Product product : productList) {
            this.assignProductAndLevel(product);
        }
    }

    protected boolean hasValidBillOfMaterial(Product product) {
        BillOfMaterial defaultBillOfMaterial = product.getDefaultBillOfMaterial();
        return !(defaultBillOfMaterial == null || defaultBillOfMaterial.getStatusSelect() != 2 && defaultBillOfMaterial.getStatusSelect() != 3 || product.getProcurementMethodSelect() != "buyAndProduce" && product.getProcurementMethodSelect() != "produce");
    }

    protected void assignProductAndLevel(Product product) {
        this.log.debug("Add of the product : {}", (Object)product.getFullName());
        this.productMap.put(product.getId(), this.getMaxLevel(product, 0));
        if (this.hasValidBillOfMaterial(product)) {
            this.assignProductLevel(product.getDefaultBillOfMaterial(), 0);
        }
    }

    protected int getMaxLevel(Product product, int level) {
        if (this.productMap.containsKey(product.getId())) {
            return Math.max(level, this.productMap.get(product.getId()));
        }
        return level;
    }

    protected int getMaxLevel() {
        int maxLevel = 0;
        for (int level : this.productMap.values()) {
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    protected void assignProductLevel(BillOfMaterial billOfMaterial, int level) {
        if (billOfMaterial.getBillOfMaterialSet() == null || billOfMaterial.getBillOfMaterialSet().isEmpty() || level > 100) {
            Product subProduct = billOfMaterial.getProduct();
            this.log.debug("Add of the sub product : {} for the level : {} ", (Object)subProduct.getFullName(), (Object)level);
            this.productMap.put(subProduct.getId(), this.getMaxLevel(subProduct, level));
        } else {
            ++level;
            for (BillOfMaterial subBillOfMaterial : billOfMaterial.getBillOfMaterialSet()) {
                Product subProduct = subBillOfMaterial.getProduct();
                if (!this.productMap.containsKey(subProduct.getId())) continue;
                this.assignProductLevel(subBillOfMaterial, level);
                if (!this.hasValidBillOfMaterial(subProduct)) continue;
                this.assignProductLevel(subProduct.getDefaultBillOfMaterial(), level);
            }
        }
    }

    @Override
    public void updateUnitCosts(UnitCostCalculation unitCostCalculation) throws AxelorException {
        for (UnitCostCalcLine unitCostCalcLine : unitCostCalculation.getUnitCostCalcLineList()) {
            this.updateUnitCosts((UnitCostCalcLine)((Object)this.unitCostCalcLineRepository.find(unitCostCalcLine.getId())));
            JPA.clear();
        }
        this.updateStatusProductCostPriceUpdated((UnitCostCalculation)((Object)this.unitCostCalculationRepository.find(unitCostCalculation.getId())));
    }

    @Transactional
    protected void updateUnitCosts(UnitCostCalcLine unitCostCalcLine) throws AxelorException {
        Product product = unitCostCalcLine.getProduct();
        this.productCompanyService.set(product, "costPrice", (Object)unitCostCalcLine.getCostToApply().setScale(this.appProductionService.getNbDecimalDigitForUnitPrice(), 4), unitCostCalcLine.getCompany());
        this.productService.updateSalePrice(product, unitCostCalcLine.getCompany());
    }

    @Transactional
    protected void updateStatusProductCostPriceUpdated(UnitCostCalculation unitCostCalculation) {
        unitCostCalculation.setUpdateCostDate(this.appProductionService.getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
        unitCostCalculation.setStatusSelect(3);
        this.unitCostCalculationRepository.save((Model)((Object)unitCostCalculation));
    }
}

