/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.manuforder;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.service.manuforder.ManufOrderPrintService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ManufOrderPrintServiceImpl
implements ManufOrderPrintService {
    @Override
    public String printManufOrders(List<Long> ids) throws IOException {
        final ArrayList printedManufOrders = new ArrayList();
        ModelTool.apply(ManufOrder.class, ids, (ThrowConsumer)new ThrowConsumer<ManufOrder>(){

            public void accept(ManufOrder manufOrder) throws Exception {
                printedManufOrders.add(ManufOrderPrintServiceImpl.this.print(manufOrder));
            }
        });
        String fileName = this.getManufOrdersFilename();
        return PdfTool.mergePdfToFileLink(printedManufOrders, (String)fileName);
    }

    @Override
    public String printManufOrder(ManufOrder manufOrder) throws AxelorException {
        String fileName = this.getFileName(manufOrder);
        return PdfTool.getFileLinkFromPdfFile((File)this.print(manufOrder), (String)fileName);
    }

    protected File print(ManufOrder manufOrder) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(manufOrder);
        return reportSettings.generate().getFile();
    }

    public ReportSettings prepareReportSettings(ManufOrder manufOrder) throws AxelorException {
        String title = this.getFileName(manufOrder);
        ReportSettings reportSetting = ReportFactory.createReport((String)"ManufOrder.rptdesign", (String)title);
        return reportSetting.addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", manufOrder.getCompany() != null ? manufOrder.getCompany().getTimezone() : null).addParam("ManufOrderId", (Object)manufOrder.getId().toString()).addParam("activateBarCodeGeneration", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getActivateBarCodeGeneration()).addFormat("pdf");
    }

    @Override
    public String getManufOrdersFilename() {
        return I18n.get((String)"Manufacturing orders") + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)).format(DateTimeFormatter.BASIC_ISO_DATE) + "." + "pdf";
    }

    @Override
    public String getFileName(ManufOrder manufOrder) {
        return I18n.get((String)"Manufacturing order") + " " + manufOrder.getManufOrderSeq() + "." + "pdf";
    }
}

