/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.manuforder;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.ProductVariantService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.ProdResidualProduct;
import com.axelor.apps.production.db.ProductionConfig;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.db.repo.ProdProductRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.config.ProductionConfigService;
import com.axelor.apps.production.service.config.StockConfigProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.manuforder.ManufOrderWorkflowService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.apps.production.service.operationorder.OperationOrderStockMoveService;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufOrderServiceImpl
implements ManufOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SequenceService sequenceService;
    protected OperationOrderService operationOrderService;
    protected ManufOrderWorkflowService manufOrderWorkflowService;
    protected ProductVariantService productVariantService;
    protected AppBaseService appBaseService;
    protected AppProductionService appProductionService;
    protected ManufOrderRepository manufOrderRepo;
    protected ProdProductRepository prodProductRepo;
    protected ProductCompanyService productCompanyService;

    @Inject
    public ManufOrderServiceImpl(SequenceService sequenceService, OperationOrderService operationOrderService, ManufOrderWorkflowService manufOrderWorkflowService, ProductVariantService productVariantService, AppBaseService appBaseService, AppProductionService appProductionService, ManufOrderRepository manufOrderRepo, ProdProductRepository prodProductRepo, ProductCompanyService productCompanyService) {
        this.sequenceService = sequenceService;
        this.operationOrderService = operationOrderService;
        this.manufOrderWorkflowService = manufOrderWorkflowService;
        this.productVariantService = productVariantService;
        this.appBaseService = appBaseService;
        this.appProductionService = appProductionService;
        this.manufOrderRepo = manufOrderRepo;
        this.prodProductRepo = prodProductRepo;
        this.productCompanyService = productCompanyService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public ManufOrder generateManufOrder(Product product, BigDecimal qtyRequested, int priority, boolean isToInvoice, BillOfMaterial billOfMaterial, LocalDateTime plannedStartDateT, LocalDateTime plannedEndDateT, int originType) throws AxelorException {
        if (billOfMaterial == null) {
            billOfMaterial = this.getBillOfMaterial(product);
        }
        Company company = billOfMaterial.getCompany();
        BigDecimal qty = qtyRequested.divide(billOfMaterial.getQty(), this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN);
        ManufOrder manufOrder = this.createManufOrder(product, qty, priority, false, company, billOfMaterial, plannedStartDateT, plannedEndDateT);
        if (originType == 2 && this.appProductionService.getAppProduction().getAutoPlanManufOrderFromSO().booleanValue() || originType == 1 || originType == 3) {
            manufOrder = this.manufOrderWorkflowService.plan(manufOrder);
        }
        return (ManufOrder)((Object)this.manufOrderRepo.save((Model)((Object)manufOrder)));
    }

    @Override
    public void createToConsumeProdProductList(ManufOrder manufOrder) {
        BigDecimal manufOrderQty = manufOrder.getQty();
        BillOfMaterial billOfMaterial = manufOrder.getBillOfMaterial();
        BigDecimal bomQty = billOfMaterial.getQty();
        if (billOfMaterial.getBillOfMaterialSet() != null) {
            for (BillOfMaterial billOfMaterialLine : this.getSortedBillsOfMaterials(billOfMaterial.getBillOfMaterialSet())) {
                if (billOfMaterialLine.getHasNoManageStock().booleanValue()) continue;
                Product product = this.productVariantService.getProductVariant(manufOrder.getProduct(), billOfMaterialLine.getProduct());
                BigDecimal qty = this.computeToConsumeProdProductLineQuantity(bomQty, manufOrderQty, billOfMaterialLine.getQty());
                ProdProduct prodProduct = new ProdProduct(product, qty, billOfMaterialLine.getUnit());
                manufOrder.addToConsumeProdProductListItem(prodProduct);
                this.prodProductRepo.persist((Model)((Object)prodProduct));
            }
        }
    }

    @Override
    public BigDecimal computeToConsumeProdProductLineQuantity(BigDecimal bomQty, BigDecimal manufOrderQty, BigDecimal lineQty) {
        BigDecimal qty = BigDecimal.ZERO;
        if (bomQty.signum() != 0) {
            qty = manufOrderQty.multiply(lineQty).divide(bomQty, this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN);
        }
        return qty;
    }

    private List<BillOfMaterial> getSortedBillsOfMaterials(Collection<BillOfMaterial> billsOfMaterials) {
        billsOfMaterials = (Collection)MoreObjects.firstNonNull(billsOfMaterials, Collections.emptyList());
        return billsOfMaterials.stream().sorted(Comparator.comparing(BillOfMaterial::getPriority).thenComparing(Comparator.comparing(BillOfMaterial::getId))).collect(Collectors.toList());
    }

    @Override
    public void createToProduceProdProductList(ManufOrder manufOrder) {
        BigDecimal manufOrderQty = manufOrder.getQty();
        BillOfMaterial billOfMaterial = manufOrder.getBillOfMaterial();
        BigDecimal bomQty = billOfMaterial.getQty();
        manufOrder.addToProduceProdProductListItem(new ProdProduct(manufOrder.getProduct(), manufOrderQty, billOfMaterial.getUnit()));
        if (this.appProductionService.getAppProduction().getManageResidualProductOnBom().booleanValue() && billOfMaterial.getProdResidualProductList() != null) {
            for (ProdResidualProduct prodResidualProduct : billOfMaterial.getProdResidualProductList()) {
                Product product = this.productVariantService.getProductVariant(manufOrder.getProduct(), prodResidualProduct.getProduct());
                BigDecimal qty = bomQty.signum() != 0 ? prodResidualProduct.getQty().multiply(manufOrderQty).divide(bomQty, this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
                manufOrder.addToProduceProdProductListItem(new ProdProduct(product, qty, prodResidualProduct.getUnit()));
            }
        }
    }

    @Override
    public ManufOrder createManufOrder(Product product, BigDecimal qty, int priority, boolean isToInvoice, Company company, BillOfMaterial billOfMaterial, LocalDateTime plannedStartDateT, LocalDateTime plannedEndDateT) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'un OF {}", (Object)priority);
        ProdProcess prodProcess = billOfMaterial.getProdProcess();
        ManufOrder manufOrder = new ManufOrder(qty, company, null, priority, this.isManagedConsumedProduct(billOfMaterial), billOfMaterial, product, prodProcess, plannedStartDateT, plannedEndDateT, 1);
        manufOrder = (ManufOrder)((Object)this.manufOrderRepo.save((Model)((Object)manufOrder)));
        if (this.appProductionService.getAppProduction().getManageWorkshop().booleanValue()) {
            manufOrder.setWorkshopStockLocation(billOfMaterial.getWorkshopStockLocation());
        }
        if (prodProcess != null && prodProcess.getProdProcessLineList() != null) {
            for (ProdProcessLine prodProcessLine : this._sortProdProcessLineByPriority(prodProcess.getProdProcessLineList())) {
                manufOrder.addOperationOrderListItem(this.operationOrderService.createOperationOrder(manufOrder, prodProcessLine));
            }
        }
        if (!manufOrder.getIsConsProOnOperation().booleanValue()) {
            this.createToConsumeProdProductList(manufOrder);
        }
        this.createToProduceProdProductList(manufOrder);
        return manufOrder;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void preFillOperations(ManufOrder manufOrder) throws AxelorException {
        BillOfMaterial billOfMaterial = manufOrder.getBillOfMaterial();
        if (manufOrder.getProdProcess() == null) {
            manufOrder.setProdProcess(billOfMaterial.getProdProcess());
        }
        ProdProcess prodProcess = manufOrder.getProdProcess();
        if (manufOrder.getPlannedStartDateT() == null) {
            manufOrder.setPlannedStartDateT(this.appProductionService.getTodayDateTime().toLocalDateTime());
        }
        if (prodProcess != null && prodProcess.getProdProcessLineList() != null) {
            for (ProdProcessLine prodProcessLine : this._sortProdProcessLineByPriority(prodProcess.getProdProcessLineList())) {
                manufOrder.addOperationOrderListItem(this.operationOrderService.createOperationOrder(manufOrder, prodProcessLine));
            }
        }
        this.manufOrderRepo.save((Model)((Object)manufOrder));
        manufOrder.setPlannedEndDateT(this.manufOrderWorkflowService.computePlannedEndDateT(manufOrder));
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    @Override
    @Transactional
    public void updateOperationsName(ManufOrder manufOrder) {
        for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
            operationOrder.setName(this.operationOrderService.computeName(manufOrder, operationOrder.getPriority(), operationOrder.getOperationName()));
        }
    }

    public List<ProdProcessLine> _sortProdProcessLineByPriority(List<ProdProcessLine> prodProcessLineList) {
        Collections.sort(prodProcessLineList, new Comparator<ProdProcessLine>(){

            @Override
            public int compare(ProdProcessLine ppl1, ProdProcessLine ppl2) {
                return ppl1.getPriority().compareTo(ppl2.getPriority());
            }
        });
        return prodProcessLineList;
    }

    @Override
    public String getManufOrderSeq(ManufOrder manufOrder) throws AxelorException {
        ProductionConfig productionConfig;
        ProductionConfigService productionConfigService = (ProductionConfigService)Beans.get(ProductionConfigService.class);
        Sequence sequence = productionConfigService.getManufOrderSequence(productionConfig = productionConfigService.getProductionConfig(manufOrder.getCompany()), manufOrder.getWorkshopStockLocation());
        String seq = this.sequenceService.getSequenceNumber(sequence);
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"There's no configured sequence for fabrication's orders"));
        }
        return seq;
    }

    @Override
    public boolean isManagedConsumedProduct(BillOfMaterial billOfMaterial) {
        if (billOfMaterial != null && billOfMaterial.getProdProcess() != null && billOfMaterial.getProdProcess().getProdProcessLineList() != null) {
            for (ProdProcessLine prodProcessLine : billOfMaterial.getProdProcess().getProdProcessLineList()) {
                if (prodProcessLine.getToConsumeProdProductList() == null || prodProcessLine.getToConsumeProdProductList().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public BillOfMaterial getBillOfMaterial(Product product) throws AxelorException {
        BillOfMaterial billOfMaterial = product.getDefaultBillOfMaterial();
        if (billOfMaterial == null && product.getParentProduct() != null) {
            billOfMaterial = product.getParentProduct().getDefaultBillOfMaterial();
        }
        if (billOfMaterial == null) {
            throw new AxelorException((Model)((Object)product), 4, I18n.get((String)"There no's defined nomenclature for product %s (%s)"), new Object[]{product.getName(), product.getCode()});
        }
        return billOfMaterial;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public StockMove generateWasteStockMove(ManufOrder manufOrder) throws AxelorException {
        StockMove wasteStockMove = null;
        Company company = manufOrder.getCompany();
        if (manufOrder.getWasteProdProductList() == null || company == null || manufOrder.getWasteProdProductList().isEmpty()) {
            return wasteStockMove;
        }
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        StockMoveLineService stockMoveLineService = (StockMoveLineService)Beans.get(StockMoveLineService.class);
        AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        StockLocation virtualStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        StockLocation wasteStockLocation = stockConfigService.getWasteStockLocation(stockConfig);
        wasteStockMove = stockMoveService.createStockMove(virtualStockLocation.getAddress(), wasteStockLocation.getAddress(), company, virtualStockLocation, wasteStockLocation, null, appBaseService.getTodayDate(company), manufOrder.getWasteProdDescription(), 1);
        for (ProdProduct prodProduct : manufOrder.getWasteProdProductList()) {
            stockMoveLineService.createStockMoveLine(prodProduct.getProduct(), (String)this.productCompanyService.get(prodProduct.getProduct(), "name", company), (String)this.productCompanyService.get(prodProduct.getProduct(), "description", company), prodProduct.getQty(), (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", company), (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", company), prodProduct.getUnit(), wasteStockMove, 5, false, BigDecimal.ZERO);
        }
        stockMoveService.validate(wasteStockMove);
        manufOrder.setWasteStockMove(wasteStockMove);
        return wasteStockMove;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updatePlannedQty(ManufOrder manufOrder) throws AxelorException {
        manufOrder.clearToConsumeProdProductList();
        manufOrder.clearToProduceProdProductList();
        this.createToConsumeProdProductList(manufOrder);
        this.createToProduceProdProductList(manufOrder);
        this.updateRealQty(manufOrder, manufOrder.getQty());
        LocalDateTime plannedStartDateT = manufOrder.getPlannedStartDateT();
        this.manufOrderWorkflowService.updatePlannedDates(manufOrder, plannedStartDateT != null ? plannedStartDateT : this.appProductionService.getTodayDateTime().toLocalDateTime());
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateRealQty(ManufOrder manufOrder, BigDecimal qtyToUpdate) throws AxelorException {
        ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
        if (!manufOrder.getIsConsProOnOperation().booleanValue()) {
            manufOrderStockMoveService.createNewConsumedStockMoveLineList(manufOrder, qtyToUpdate);
            this.updateDiffProdProductList(manufOrder);
        } else {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                ((OperationOrderStockMoveService)Beans.get(OperationOrderStockMoveService.class)).createNewConsumedStockMoveLineList(operationOrder, qtyToUpdate);
                ((OperationOrderService)Beans.get(OperationOrderService.class)).updateDiffProdProductList(operationOrder);
            }
        }
        manufOrderStockMoveService.createNewProducedStockMoveLineList(manufOrder, qtyToUpdate);
    }

    @Override
    public ManufOrder updateDiffProdProductList(ManufOrder manufOrder) throws AxelorException {
        List<ProdProduct> toConsumeList = manufOrder.getToConsumeProdProductList();
        List<StockMoveLine> consumedList = manufOrder.getConsumedStockMoveLineList();
        if (toConsumeList == null || consumedList == null) {
            return manufOrder;
        }
        List<ProdProduct> diffConsumeList = this.createDiffProdProductList(manufOrder, toConsumeList, consumedList);
        manufOrder.clearDiffConsumeProdProductList();
        diffConsumeList.forEach(manufOrder::addDiffConsumeProdProductListItem);
        return manufOrder;
    }

    @Override
    public List<ProdProduct> createDiffProdProductList(ManufOrder manufOrder, List<ProdProduct> prodProductList, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        List<ProdProduct> diffConsumeList = this.createDiffProdProductList(prodProductList, stockMoveLineList);
        diffConsumeList.forEach(prodProduct -> prodProduct.setDiffConsumeManufOrder(manufOrder));
        return diffConsumeList;
    }

    @Override
    public List<ProdProduct> createDiffProdProductList(List<ProdProduct> prodProductList, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        ArrayList<ProdProduct> diffConsumeList = new ArrayList<ProdProduct>();
        for (ProdProduct prodProduct : prodProductList) {
            Product product = prodProduct.getProduct();
            Unit newUnit = prodProduct.getUnit();
            List<StockMoveLine> stockMoveLineProductList = stockMoveLineList.stream().filter(stockMoveLine1 -> stockMoveLine1.getProduct() != null).filter(stockMoveLine1 -> stockMoveLine1.getProduct().equals((Object)product)).collect(Collectors.toList());
            if (stockMoveLineProductList.isEmpty()) {
                StockMoveLine stockMoveLine = new StockMoveLine();
                stockMoveLineProductList.add(stockMoveLine);
            }
            BigDecimal diffQty = this.computeDiffQty(prodProduct, stockMoveLineProductList, product);
            BigDecimal plannedQty = prodProduct.getQty();
            BigDecimal realQty = diffQty.add(plannedQty);
            if (diffQty.compareTo(BigDecimal.ZERO) == 0) continue;
            ProdProduct diffProdProduct = new ProdProduct();
            diffProdProduct.setQty(diffQty);
            diffProdProduct.setPlannedQty(plannedQty);
            diffProdProduct.setRealQty(realQty);
            diffProdProduct.setProduct(product);
            diffProdProduct.setUnit(newUnit);
            diffConsumeList.add(diffProdProduct);
        }
        List stockMoveLineMissingProductList = stockMoveLineList.stream().filter(stockMoveLine1 -> stockMoveLine1.getProduct() != null).filter(stockMoveLine1 -> !prodProductList.stream().map(ProdProduct::getProduct).collect(Collectors.toList()).contains((Object)stockMoveLine1.getProduct())).collect(Collectors.toList());
        for (StockMoveLine stockMoveLine : stockMoveLineMissingProductList) {
            if (stockMoveLine.getQty().compareTo(BigDecimal.ZERO) == 0) continue;
            ProdProduct diffProdProduct = new ProdProduct();
            diffProdProduct.setQty(stockMoveLine.getQty());
            diffProdProduct.setPlannedQty(BigDecimal.ZERO);
            diffProdProduct.setRealQty(stockMoveLine.getQty());
            diffProdProduct.setProduct(stockMoveLine.getProduct());
            diffProdProduct.setUnit(stockMoveLine.getUnit());
            diffConsumeList.add(diffProdProduct);
        }
        return diffConsumeList;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateConsumedStockMoveFromManufOrder(ManufOrder manufOrder) throws AxelorException {
        StockMove stockMove;
        this.updateDiffProdProductList(manufOrder);
        List<StockMoveLine> consumedStockMoveLineList = manufOrder.getConsumedStockMoveLineList();
        if (consumedStockMoveLineList == null) {
            return;
        }
        ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
        Optional<StockMove> stockMoveOpt = manufOrderStockMoveService.getPlannedStockMove(manufOrder.getInStockMoveList());
        if (stockMoveOpt.isPresent()) {
            stockMove = stockMoveOpt.get();
        } else {
            stockMove = manufOrderStockMoveService._createToConsumeStockMove(manufOrder, manufOrder.getCompany());
            manufOrder.addInStockMoveListItem(stockMove);
            ((StockMoveService)Beans.get(StockMoveService.class)).plan(stockMove);
        }
        this.updateStockMoveFromManufOrder(consumedStockMoveLineList, stockMove);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateProducedStockMoveFromManufOrder(ManufOrder manufOrder) throws AxelorException {
        StockMove stockMove;
        List<StockMoveLine> producedStockMoveLineList = manufOrder.getProducedStockMoveLineList();
        ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
        Optional<StockMove> stockMoveOpt = manufOrderStockMoveService.getPlannedStockMove(manufOrder.getOutStockMoveList());
        if (stockMoveOpt.isPresent()) {
            stockMove = stockMoveOpt.get();
        } else {
            stockMove = manufOrderStockMoveService._createToProduceStockMove(manufOrder, manufOrder.getCompany());
            manufOrder.addOutStockMoveListItem(stockMove);
            ((StockMoveService)Beans.get(StockMoveService.class)).plan(stockMove);
        }
        this.updateStockMoveFromManufOrder(producedStockMoveLineList, stockMove);
    }

    @Override
    public void checkConsumedStockMoveLineList(ManufOrder manufOrder, ManufOrder oldManufOrder) throws AxelorException {
        this.checkRealizedStockMoveLineList(manufOrder.getConsumedStockMoveLineList(), oldManufOrder.getConsumedStockMoveLineList());
    }

    @Override
    public void checkProducedStockMoveLineList(ManufOrder manufOrder, ManufOrder oldManufOrder) throws AxelorException {
        this.checkRealizedStockMoveLineList(manufOrder.getProducedStockMoveLineList(), oldManufOrder.getProducedStockMoveLineList());
    }

    @Override
    public void checkRealizedStockMoveLineList(List<StockMoveLine> stockMoveLineList, List<StockMoveLine> oldStockMoveLineList) throws AxelorException {
        List oldRealizedProducedStockMoveLineList;
        List realizedProducedStockMoveLineList = stockMoveLineList.stream().filter(stockMoveLine -> stockMoveLine.getStockMove() != null && stockMoveLine.getStockMove().getStatusSelect() == 3).sorted(Comparator.comparingLong(StockMoveLine::getId)).collect(Collectors.toList());
        if (!realizedProducedStockMoveLineList.equals(oldRealizedProducedStockMoveLineList = oldStockMoveLineList.stream().filter(stockMoveLine -> stockMoveLine.getStockMove() != null && stockMoveLine.getStockMove().getStatusSelect() == 3).sorted(Comparator.comparingLong(StockMoveLine::getId)).collect(Collectors.toList()))) {
            throw new AxelorException(5, I18n.get((String)"You cannot delete realized stock move lines."));
        }
    }

    @Override
    public void updateStockMoveFromManufOrder(List<StockMoveLine> stockMoveLineList, StockMove stockMove) throws AxelorException {
        if (stockMoveLineList == null) {
            return;
        }
        stockMoveLineList.stream().filter(stockMoveLine -> stockMoveLine.getStockMove() == null).forEach(stockMove::addStockMoveLineListItem);
        if (stockMove.getStockMoveLineList() != null) {
            stockMove.getStockMoveLineList().removeIf(stockMoveLine -> !stockMoveLineList.contains(stockMoveLine));
        }
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        stockMoveService.cancel(stockMove);
        stockMoveService.plan(stockMove);
    }

    protected BigDecimal computeDiffQty(ProdProduct prodProduct, List<StockMoveLine> stockMoveLineList, Product product) throws AxelorException {
        BigDecimal consumedQty = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            if (stockMoveLine.getUnit() != null && prodProduct.getUnit() != null) {
                consumedQty = consumedQty.add(((UnitConversionService)Beans.get(UnitConversionService.class)).convert(stockMoveLine.getUnit(), prodProduct.getUnit(), stockMoveLine.getQty(), stockMoveLine.getQty().scale(), product));
                continue;
            }
            consumedQty = consumedQty.add(stockMoveLine.getQty());
        }
        return consumedQty.subtract(prodProduct.getQty());
    }

    @Override
    public String getConsumeAndMissingQtyForAProduct(Long productId, Long companyId, Long stockLocationId) {
        List<Integer> statusList = this.getMOFiltersOnProductionConfig();
        String statusListQuery = statusList.stream().map(String::valueOf).collect(Collectors.joining(","));
        String query = "self.product.id = " + productId + " AND self.stockMove.statusSelect = " + 2 + " AND self.stockMove.fromStockLocation.typeSelect != " + 3 + " AND ( (self.consumedManufOrder IS NOT NULL AND self.consumedManufOrder.statusSelect IN (" + statusListQuery + ")) OR (self.consumedOperationOrder IS NOT NULL AND self.consumedOperationOrder.statusSelect IN ( " + statusListQuery + ") ) ) ";
        if (companyId != 0L) {
            query = query + " AND self.stockMove.company.id = " + companyId;
            if (stockLocationId != 0L && stockLocationId != 0L) {
                StockLocation stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId));
                List stockLocationList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocation(stockLocation, false);
                if (!stockLocationList.isEmpty() && stockLocation.getCompany().getId() == companyId) {
                    query = query + " AND self.stockMove.fromStockLocation.id IN (" + StringTool.getIdListString((Collection)stockLocationList) + ") ";
                }
            }
        }
        return query;
    }

    @Override
    public String getBuildingQtyForAProduct(Long productId, Long companyId, Long stockLocationId) {
        List<Integer> statusList = this.getMOFiltersOnProductionConfig();
        String statusListQuery = statusList.stream().map(String::valueOf).collect(Collectors.joining(","));
        String query = "self.product.id = " + productId + " AND self.stockMove.statusSelect = " + 2 + " AND self.stockMove.toStockLocation.typeSelect != " + 3 + " AND self.producedManufOrder IS NOT NULL  AND self.producedManufOrder.statusSelect IN ( " + statusListQuery + " )";
        if (companyId != 0L) {
            query = query + "AND self.stockMove.company.id = " + companyId;
            if (stockLocationId != 0L) {
                StockLocation stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId));
                List stockLocationList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocation(stockLocation, false);
                if (!stockLocationList.isEmpty() && stockLocation.getCompany().getId() == companyId) {
                    query = query + " AND self.stockMove.toStockLocation.id IN (" + StringTool.getIdListString((Collection)stockLocationList) + ") ";
                }
            }
        }
        return query;
    }

    private List<Integer> getMOFiltersOnProductionConfig() {
        List<Integer> statusList = new ArrayList<Integer>();
        statusList.add(4);
        statusList.add(5);
        String status = this.appProductionService.getAppProduction().getmOFilterOnStockDetailStatusSelect();
        if (!StringUtils.isBlank((CharSequence)status)) {
            statusList = StringTool.getIntegerList((String)status);
        }
        return statusList;
    }
}

