/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.manuforder;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.config.StockConfigProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.operationorder.OperationOrderStockMoveService;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufOrderStockMoveService {
    public static final int PART_FINISH_IN = 1;
    public static final int PART_FINISH_OUT = 2;
    public static final int STOCK_LOCATION_IN = 1;
    public static final int STOCK_LOCATION_OUT = 2;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected StockMoveService stockMoveService;
    protected StockMoveLineService stockMoveLineService;
    protected AppBaseService appBaseService;
    protected ProductCompanyService productCompanyService;

    @Inject
    public ManufOrderStockMoveService(StockMoveService stockMoveService, StockMoveLineService stockMoveLineService, AppBaseService appBaseService, ProductCompanyService productCompanyService) {
        this.stockMoveService = stockMoveService;
        this.stockMoveLineService = stockMoveLineService;
        this.appBaseService = appBaseService;
        this.productCompanyService = productCompanyService;
    }

    public void createToConsumeStockMove(ManufOrder manufOrder) throws AxelorException {
        Company company = manufOrder.getCompany();
        if (manufOrder.getToConsumeProdProductList() != null && company != null) {
            StockMove stockMove = this._createToConsumeStockMove(manufOrder, company);
            for (ProdProduct prodProduct : manufOrder.getToConsumeProdProductList()) {
                this._createStockMoveLine(prodProduct, stockMove, 4);
            }
            if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                this.stockMoveService.plan(stockMove);
                manufOrder.addInStockMoveListItem(stockMove);
            }
            if (stockMove.getStockMoveLineList() != null) {
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    manufOrder.addConsumedStockMoveLineListItem(stockMoveLine);
                }
            }
        }
    }

    public StockMove _createToConsumeStockMove(ManufOrder manufOrder, Company company) throws AxelorException {
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        StockLocation virtualStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        StockLocation fromStockLocation = this.getDefaultStockLocation(manufOrder, company, 1);
        StockMove stockMove = this.stockMoveService.createStockMove(null, null, company, fromStockLocation, virtualStockLocation, null, manufOrder.getPlannedStartDateT().toLocalDate(), null, 1);
        stockMove.setOriginId(manufOrder.getId());
        stockMove.setOriginTypeSelect("com.axelor.apps.production.db.ManufOrder");
        stockMove.setOrigin(manufOrder.getManufOrderSeq());
        return stockMove;
    }

    public StockLocation getDefaultStockLocation(ManufOrder manufOrder, Company company, int inOrOut) throws AxelorException {
        if (inOrOut != 1 && inOrOut != 2) {
            throw new IllegalArgumentException(I18n.get((String)"inOrOut is invalid"));
        }
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        StockLocation stockLocation = this.getDefaultStockLocation(manufOrder.getProdProcess(), inOrOut);
        if (stockLocation == null) {
            stockLocation = inOrOut == 1 ? stockConfigService.getComponentDefaultStockLocation(stockConfig) : stockConfigService.getFinishedProductsDefaultStockLocation(stockConfig);
        }
        return stockLocation;
    }

    protected StockLocation getDefaultStockLocation(ProdProcess prodProcess, int inOrOut) {
        if (inOrOut != 1 && inOrOut != 2) {
            throw new IllegalArgumentException(I18n.get((String)"inOrOut is invalid"));
        }
        if (prodProcess == null) {
            return null;
        }
        if (inOrOut == 1) {
            return prodProcess.getStockLocation();
        }
        return prodProcess.getProducedProductStockLocation();
    }

    public void createToProduceStockMove(ManufOrder manufOrder) throws AxelorException {
        Company company = manufOrder.getCompany();
        if (manufOrder.getToProduceProdProductList() != null && company != null) {
            StockMove stockMove = this._createToProduceStockMove(manufOrder, company);
            for (ProdProduct prodProduct : manufOrder.getToProduceProdProductList()) {
                BigDecimal productCostPrice = prodProduct.getProduct() != null ? (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", manufOrder.getCompany()) : BigDecimal.ZERO;
                this._createStockMoveLine(prodProduct, stockMove, 3, prodProduct.getQty(), productCostPrice);
            }
            if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                this.stockMoveService.plan(stockMove);
                manufOrder.addOutStockMoveListItem(stockMove);
            }
            if (stockMove.getStockMoveLineList() != null) {
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    manufOrder.addProducedStockMoveLineListItem(stockMoveLine);
                }
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void consumeInStockMoves(ManufOrder manufOrder) throws AxelorException {
        for (StockMove stockMove : manufOrder.getInStockMoveList()) {
            this.finishStockMove(stockMove);
        }
    }

    protected StockMove _createToProduceStockMove(ManufOrder manufOrder, Company company) throws AxelorException {
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        StockLocation virtualStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        LocalDateTime plannedEndDateT = manufOrder.getPlannedEndDateT();
        LocalDate plannedEndDate = plannedEndDateT != null ? plannedEndDateT.toLocalDate() : null;
        StockLocation producedProductStockLocation = manufOrder.getProdProcess().getProducedProductStockLocation();
        if (producedProductStockLocation == null) {
            producedProductStockLocation = stockConfigService.getFinishedProductsDefaultStockLocation(stockConfig);
        }
        StockMove stockMove = this.stockMoveService.createStockMove(null, null, company, virtualStockLocation, producedProductStockLocation, null, plannedEndDate, null, 1);
        stockMove.setOriginId(manufOrder.getId());
        stockMove.setOriginTypeSelect("com.axelor.apps.production.db.ManufOrder");
        stockMove.setOrigin(manufOrder.getManufOrderSeq());
        return stockMove;
    }

    protected StockMoveLine _createStockMoveLine(ProdProduct prodProduct, StockMove stockMove, int inOrOutType) throws AxelorException {
        return this._createStockMoveLine(prodProduct, stockMove, inOrOutType, prodProduct.getQty());
    }

    public StockMoveLine _createStockMoveLine(ProdProduct prodProduct, StockMove stockMove, int inOrOutType, BigDecimal qty) throws AxelorException {
        BigDecimal productCostPrice = prodProduct.getProduct() != null ? (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", stockMove.getCompany()) : BigDecimal.ZERO;
        return this._createStockMoveLine(prodProduct, stockMove, inOrOutType, qty, productCostPrice);
    }

    protected StockMoveLine _createStockMoveLine(ProdProduct prodProduct, StockMove stockMove, int inOrOutType, BigDecimal qty, BigDecimal costPrice) throws AxelorException {
        return this.stockMoveLineService.createStockMoveLine(prodProduct.getProduct(), (String)this.productCompanyService.get(prodProduct.getProduct(), "name", stockMove.getCompany()), (String)this.productCompanyService.get(prodProduct.getProduct(), "description", stockMove.getCompany()), qty, costPrice, costPrice, prodProduct.getUnit(), stockMove, inOrOutType, false, BigDecimal.ZERO);
    }

    public void finish(ManufOrder manufOrder) throws AxelorException {
        manufOrder.getInStockMoveList().removeIf(stockMove -> CollectionUtils.isEmpty(stockMove.getStockMoveLineList()));
        manufOrder.getOutStockMoveList().removeIf(stockMove -> CollectionUtils.isEmpty(stockMove.getStockMoveLineList()));
        for (StockMove stockMove2 : manufOrder.getInStockMoveList()) {
            this.finishStockMove(stockMove2);
        }
        for (StockMove stockMove2 : manufOrder.getOutStockMoveList()) {
            this.updateRealPrice(manufOrder, stockMove2);
            this.finishStockMove(stockMove2);
        }
    }

    protected void updateRealPrice(ManufOrder manufOrder, StockMove stockMove) {
        stockMove.getStockMoveLineList().stream().filter(stockMoveLine -> stockMoveLine.getProduct() != null && stockMoveLine.getProduct().getRealOrEstimatedPriceSelect() == 2).forEach(stockMoveLine -> stockMoveLine.setUnitPriceUntaxed(manufOrder.getCostPrice()));
    }

    public void finishStockMove(StockMove stockMove) throws AxelorException {
        if (stockMove != null && stockMove.getStatusSelect() == 2) {
            stockMove.setIsWithBackorder(false);
            this.stockMoveService.copyQtyToRealQty(stockMove);
            this.stockMoveService.realize(stockMove);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void partialFinish(ManufOrder manufOrder) throws AxelorException {
        if (manufOrder.getIsConsProOnOperation().booleanValue()) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() != 4) continue;
                ((OperationOrderStockMoveService)Beans.get(OperationOrderStockMoveService.class)).partialFinish(operationOrder);
            }
        } else {
            this.partialFinish(manufOrder, 1);
        }
        this.partialFinish(manufOrder, 2);
        ((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).save((Model)((Object)manufOrder));
    }

    protected void partialFinish(ManufOrder manufOrder, int inOrOut) throws AxelorException {
        StockLocation toStockLocation;
        StockLocation fromStockLocation;
        List<StockMove> stockMoveList;
        if (inOrOut != 1 && inOrOut != 2) {
            throw new IllegalArgumentException(I18n.get((String)"inOrOut is invalid"));
        }
        Company company = manufOrder.getCompany();
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        if (inOrOut == 1) {
            stockMoveList = manufOrder.getInStockMoveList();
            fromStockLocation = this.getDefaultStockLocation(manufOrder, company, 1);
            toStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        } else {
            stockMoveList = manufOrder.getOutStockMoveList();
            fromStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
            toStockLocation = this.getDefaultStockLocation(manufOrder, company, 2);
        }
        Optional<StockMove> stockMoveToRealize = this.getPlannedStockMove(stockMoveList);
        if (stockMoveToRealize.isPresent()) {
            this.updateRealPrice(manufOrder, stockMoveToRealize.get());
            this.finishStockMove(stockMoveToRealize.get());
        }
        StockMove newStockMove = this.stockMoveService.createStockMove(null, null, company, fromStockLocation, toStockLocation, null, manufOrder.getPlannedStartDateT().toLocalDate(), null, 1);
        newStockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        newStockMove.setOrigin(manufOrder.getManufOrderSeq());
        newStockMove.setOriginId(manufOrder.getId());
        newStockMove.setOriginTypeSelect("com.axelor.apps.production.db.ManufOrder");
        this.createNewStockMoveLines(manufOrder, newStockMove, inOrOut);
        if (!newStockMove.getStockMoveLineList().isEmpty()) {
            this.stockMoveService.plan(newStockMove);
            if (inOrOut == 1) {
                manufOrder.addInStockMoveListItem(newStockMove);
                newStockMove.getStockMoveLineList().forEach(manufOrder::addConsumedStockMoveLineListItem);
                manufOrder.clearDiffConsumeProdProductList();
            } else {
                manufOrder.addOutStockMoveListItem(newStockMove);
                newStockMove.getStockMoveLineList().forEach(manufOrder::addProducedStockMoveLineListItem);
            }
        }
    }

    public Optional<StockMove> getPlannedStockMove(List<StockMove> stockMoveList) {
        return stockMoveList.stream().filter(stockMove -> stockMove.getStatusSelect() == 2).findFirst();
    }

    public void createNewStockMoveLines(ManufOrder manufOrder, StockMove stockMove, int inOrOut) throws AxelorException {
        List<ProdProduct> diffProdProductList;
        int stockMoveLineType;
        if (inOrOut == 1) {
            stockMoveLineType = 4;
            diffProdProductList = new ArrayList<ProdProduct>(manufOrder.getDiffConsumeProdProductList());
        } else {
            stockMoveLineType = 3;
            List<ProdProduct> outProdProductList = manufOrder.getToProduceProdProductList();
            List<StockMoveLine> stockMoveLineList = manufOrder.getProducedStockMoveLineList();
            if (outProdProductList == null || stockMoveLineList == null) {
                return;
            }
            diffProdProductList = ((ManufOrderService)Beans.get(ManufOrderService.class)).createDiffProdProductList(manufOrder, outProdProductList, stockMoveLineList);
        }
        this.createNewStockMoveLines(diffProdProductList, stockMove, stockMoveLineType);
    }

    public void createNewStockMoveLines(List<ProdProduct> diffProdProductList, StockMove stockMove, int stockMoveLineType) throws AxelorException {
        diffProdProductList.forEach(prodProduct -> prodProduct.setQty(prodProduct.getQty().negate()));
        for (ProdProduct prodProduct2 : diffProdProductList) {
            if (prodProduct2.getQty().signum() < 0) continue;
            this._createStockMoveLine(prodProduct2, stockMove, stockMoveLineType);
        }
    }

    public void cancel(ManufOrder manufOrder) throws AxelorException {
        for (StockMove stockMove : manufOrder.getInStockMoveList()) {
            this.cancel(stockMove);
        }
        for (StockMove stockMove : manufOrder.getOutStockMoveList()) {
            this.cancel(stockMove);
        }
    }

    public void cancel(StockMove stockMove) throws AxelorException {
        if (stockMove != null) {
            this.stockMoveService.cancel(stockMove);
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                stockMoveLine.setProducedManufOrder(null);
            }
        }
    }

    public void createNewConsumedStockMoveLineList(ManufOrder manufOrder, BigDecimal qtyToUpdate) throws AxelorException {
        Optional<StockMove> stockMoveOpt = this.getPlannedStockMove(manufOrder.getInStockMoveList());
        if (!stockMoveOpt.isPresent()) {
            return;
        }
        StockMove stockMove = stockMoveOpt.get();
        this.stockMoveService.cancel(stockMove);
        manufOrder.getConsumedStockMoveLineList().removeIf(stockMoveLine -> stockMoveLine.getStockMove().getStatusSelect() == 4);
        stockMove.clearStockMoveLineList();
        for (ProdProduct prodProduct : manufOrder.getToConsumeProdProductList()) {
            BigDecimal qty = this.getFractionQty(manufOrder, prodProduct, qtyToUpdate);
            this._createStockMoveLine(prodProduct, stockMove, 4, qty);
            stockMove.getStockMoveLineList().stream().filter(stockMoveLine1 -> !manufOrder.getConsumedStockMoveLineList().contains(stockMoveLine1)).forEach(manufOrder::addConsumedStockMoveLineListItem);
        }
        this.stockMoveService.plan(stockMove);
    }

    public void createNewProducedStockMoveLineList(ManufOrder manufOrder, BigDecimal qtyToUpdate) throws AxelorException {
        Optional<StockMove> stockMoveOpt = this.getPlannedStockMove(manufOrder.getOutStockMoveList());
        if (!stockMoveOpt.isPresent()) {
            return;
        }
        StockMove stockMove = stockMoveOpt.get();
        this.stockMoveService.cancel(stockMove);
        manufOrder.getProducedStockMoveLineList().removeIf(stockMoveLine -> stockMoveLine.getStockMove().getStatusSelect() == 4);
        stockMove.clearStockMoveLineList();
        for (ProdProduct prodProduct : manufOrder.getToProduceProdProductList()) {
            BigDecimal qty = this.getFractionQty(manufOrder, prodProduct, qtyToUpdate);
            BigDecimal productCostPrice = prodProduct.getProduct() != null ? (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", manufOrder.getCompany()) : BigDecimal.ZERO;
            this._createStockMoveLine(prodProduct, stockMove, 3, qty, productCostPrice);
            stockMove.getStockMoveLineList().stream().filter(stockMoveLine1 -> !manufOrder.getProducedStockMoveLineList().contains(stockMoveLine1)).forEach(manufOrder::addProducedStockMoveLineListItem);
        }
        this.stockMoveService.plan(stockMove);
    }

    public BigDecimal getFractionQty(ManufOrder manufOrder, ProdProduct prodProduct, BigDecimal qtyToUpdate) {
        BigDecimal manufOrderQty = manufOrder.getQty();
        BigDecimal prodProductQty = prodProduct.getQty();
        int scale = this.appBaseService.getNbDecimalDigitForQty();
        return qtyToUpdate.multiply(prodProductQty).setScale(scale, RoundingMode.HALF_EVEN).divide(manufOrderQty, scale, RoundingMode.HALF_EVEN);
    }
}

