/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.operationorder;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.service.config.StockConfigProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class OperationOrderStockMoveService {
    protected StockMoveService stockMoveService;
    protected StockMoveLineService stockMoveLineService;
    protected StockLocationRepository stockLocationRepo;
    protected ProductCompanyService productCompanyService;

    @Inject
    public OperationOrderStockMoveService(StockMoveService stockMoveService, StockMoveLineService stockMoveLineService, StockLocationRepository stockLocationRepo, ProductCompanyService productCompanyService) {
        this.stockMoveService = stockMoveService;
        this.stockMoveLineService = stockMoveLineService;
        this.stockLocationRepo = stockLocationRepo;
        this.productCompanyService = productCompanyService;
    }

    public void createToConsumeStockMove(OperationOrder operationOrder) throws AxelorException {
        Company company = operationOrder.getManufOrder().getCompany();
        if (operationOrder.getToConsumeProdProductList() != null && company != null) {
            StockMove stockMove = this._createToConsumeStockMove(operationOrder, company);
            stockMove.setOriginId(operationOrder.getId());
            stockMove.setOriginTypeSelect("com.axelor.apps.production.db.OperationOrder");
            stockMove.setOrigin(operationOrder.getOperationName());
            for (ProdProduct prodProduct : operationOrder.getToConsumeProdProductList()) {
                StockMoveLine stockMoveLine = this._createStockMoveLine(prodProduct, stockMove);
            }
            if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
                this.stockMoveService.plan(stockMove);
                operationOrder.addInStockMoveListItem(stockMove);
            }
            if (stockMove.getStockMoveLineList() != null) {
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    operationOrder.addConsumedStockMoveLineListItem(stockMoveLine);
                }
            }
        }
    }

    protected StockMove _createToConsumeStockMove(OperationOrder operationOrder, Company company) throws AxelorException {
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        StockLocation virtualStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        ProdProcessLine prodProcessLine = operationOrder.getProdProcessLine();
        StockLocation fromStockLocation = operationOrder.getManufOrder().getIsConsProOnOperation() != false && prodProcessLine != null && prodProcessLine.getStockLocation() != null ? prodProcessLine.getStockLocation() : (operationOrder.getManufOrder().getIsConsProOnOperation() == false && prodProcessLine != null && prodProcessLine.getProdProcess() != null && prodProcessLine.getProdProcess().getStockLocation() != null ? prodProcessLine.getProdProcess().getStockLocation() : stockConfigService.getComponentDefaultStockLocation(stockConfig));
        return this.stockMoveService.createStockMove(null, null, company, fromStockLocation, virtualStockLocation, null, operationOrder.getPlannedStartDateT().toLocalDate(), null, 1);
    }

    protected StockMoveLine _createStockMoveLine(ProdProduct prodProduct, StockMove stockMove) throws AxelorException {
        return this.stockMoveLineService.createStockMoveLine(prodProduct.getProduct(), (String)this.productCompanyService.get(prodProduct.getProduct(), "name", stockMove.getCompany()), (String)this.productCompanyService.get(prodProduct.getProduct(), "name", stockMove.getCompany()), prodProduct.getQty(), (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", stockMove.getCompany()), (BigDecimal)this.productCompanyService.get(prodProduct.getProduct(), "costPrice", stockMove.getCompany()), prodProduct.getUnit(), stockMove, 4, false, BigDecimal.ZERO);
    }

    public void finish(OperationOrder operationOrder) throws AxelorException {
        List<StockMove> stockMoveList = operationOrder.getInStockMoveList();
        if (stockMoveList != null) {
            stockMoveList.removeIf(stockMove -> CollectionUtils.isEmpty(stockMove.getStockMoveLineList()));
            for (StockMove stockMove2 : stockMoveList) {
                ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class)).finishStockMove(stockMove2);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void partialFinish(OperationOrder operationOrder) throws AxelorException {
        ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
        ManufOrder manufOrder = operationOrder.getManufOrder();
        Company company = manufOrder.getCompany();
        StockConfigProductionService stockConfigService = (StockConfigProductionService)((Object)Beans.get(StockConfigProductionService.class));
        StockConfig stockConfig = stockConfigService.getStockConfig(company);
        List<StockMove> stockMoveList = operationOrder.getInStockMoveList();
        StockLocation fromStockLocation = manufOrderStockMoveService.getDefaultStockLocation(manufOrder, company, 1);
        StockLocation toStockLocation = stockConfigService.getProductionVirtualStockLocation(stockConfig);
        Optional<StockMove> stockMoveToRealize = stockMoveList.stream().filter(stockMove -> stockMove.getStatusSelect() == 2 && !CollectionUtils.isEmpty(stockMove.getStockMoveLineList())).findFirst();
        if (stockMoveToRealize.isPresent()) {
            manufOrderStockMoveService.finishStockMove(stockMoveToRealize.get());
        }
        StockMove newStockMove = this.stockMoveService.createStockMove(null, null, company, fromStockLocation, toStockLocation, null, operationOrder.getPlannedStartDateT().toLocalDate(), null, 1);
        newStockMove.setOrigin(operationOrder.getOperationName());
        newStockMove.setOriginId(operationOrder.getId());
        newStockMove.setOriginTypeSelect("com.axelor.apps.production.db.OperationOrder");
        newStockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        this.createNewStockMoveLines(operationOrder, newStockMove);
        if (!newStockMove.getStockMoveLineList().isEmpty()) {
            this.stockMoveService.plan(newStockMove);
            operationOrder.addInStockMoveListItem(newStockMove);
            newStockMove.getStockMoveLineList().forEach(operationOrder::addConsumedStockMoveLineListItem);
            operationOrder.clearDiffConsumeProdProductList();
        }
    }

    public void createNewStockMoveLines(OperationOrder operationOrder, StockMove stockMove) throws AxelorException {
        ((OperationOrderService)Beans.get(OperationOrderService.class)).updateDiffProdProductList(operationOrder);
        ArrayList<ProdProduct> diffProdProductList = new ArrayList<ProdProduct>(operationOrder.getDiffConsumeProdProductList());
        ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class)).createNewStockMoveLines(diffProdProductList, stockMove, 4);
    }

    public void cancel(OperationOrder operationOrder) throws AxelorException {
        List<StockMove> stockMoveList = operationOrder.getInStockMoveList();
        if (stockMoveList != null) {
            for (StockMove stockMove2 : stockMoveList) {
                this.stockMoveService.cancel(stockMove2);
            }
            stockMoveList.stream().filter(stockMove -> stockMove.getStockMoveLineList() != null).flatMap(stockMove -> stockMove.getStockMoveLineList().stream()).forEach(stockMoveLine -> stockMoveLine.setConsumedOperationOrder(null));
        }
    }

    public void createNewConsumedStockMoveLineList(OperationOrder operationOrder, BigDecimal qtyToUpdate) throws AxelorException {
        ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
        Optional<StockMove> stockMoveOpt = manufOrderStockMoveService.getPlannedStockMove(operationOrder.getInStockMoveList());
        if (!stockMoveOpt.isPresent()) {
            return;
        }
        StockMove stockMove = stockMoveOpt.get();
        this.stockMoveService.cancel(stockMove);
        operationOrder.getConsumedStockMoveLineList().removeIf(stockMoveLine -> stockMoveLine.getStockMove().getStatusSelect() == 4);
        stockMove.clearStockMoveLineList();
        for (ProdProduct prodProduct : operationOrder.getToConsumeProdProductList()) {
            BigDecimal qty = manufOrderStockMoveService.getFractionQty(operationOrder.getManufOrder(), prodProduct, qtyToUpdate);
            manufOrderStockMoveService._createStockMoveLine(prodProduct, stockMove, 4, qty);
            stockMove.getStockMoveLineList().stream().filter(stockMoveLine1 -> !operationOrder.getConsumedStockMoveLineList().contains(stockMoveLine1)).forEach(operationOrder::addConsumedStockMoveLineListItem);
        }
        this.stockMoveService.plan(stockMove);
    }
}

