/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.productionorder;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionOrderServiceImpl
implements ProductionOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ManufOrderService manufOrderService;
    protected SequenceService sequenceService;
    protected ProductionOrderRepository productionOrderRepo;

    @Inject
    public ProductionOrderServiceImpl(ManufOrderService manufOrderService, SequenceService sequenceService, ProductionOrderRepository productionOrderRepo) {
        this.manufOrderService = manufOrderService;
        this.sequenceService = sequenceService;
        this.productionOrderRepo = productionOrderRepo;
    }

    @Override
    public ProductionOrder createProductionOrder(SaleOrder saleOrder) throws AxelorException {
        ProductionOrder productionOrder = new ProductionOrder(this.getProductionOrderSeq());
        if (saleOrder != null) {
            productionOrder.setClientPartner(saleOrder.getClientPartner());
            productionOrder.setSaleOrder(saleOrder);
        }
        return productionOrder;
    }

    @Override
    public String getProductionOrderSeq() throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("productionOrder");
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"There's no configured sequence for production's orders"));
        }
        return seq;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public ProductionOrder generateProductionOrder(Product product, BillOfMaterial billOfMaterial, BigDecimal qtyRequested, LocalDateTime startDate) throws AxelorException {
        ProductionOrder productionOrder = this.createProductionOrder(null);
        this.addManufOrder(productionOrder, product, billOfMaterial, qtyRequested, startDate, null, null, 3);
        return (ProductionOrder)((Object)this.productionOrderRepo.save((Model)((Object)productionOrder)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public ProductionOrder addManufOrder(ProductionOrder productionOrder, Product product, BillOfMaterial billOfMaterial, BigDecimal qtyRequested, LocalDateTime startDate, LocalDateTime endDate, SaleOrder saleOrder, int originType) throws AxelorException {
        ManufOrder manufOrder = this.manufOrderService.generateManufOrder(product, qtyRequested, 2, false, billOfMaterial, startDate, endDate, originType);
        if (manufOrder != null) {
            if (saleOrder != null) {
                manufOrder.setSaleOrder(saleOrder);
                manufOrder.setClientPartner(saleOrder.getClientPartner());
                manufOrder.setMoCommentFromSaleOrder(saleOrder.getProductionNote());
            }
            productionOrder.addManufOrderListItem(manufOrder);
        }
        return (ProductionOrder)((Object)this.productionOrderRepo.save((Model)((Object)productionOrder)));
    }
}

