/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.productionorder;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.production.service.productionorder.ProductionOrderWizardService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionOrderWizardServiceImpl
implements ProductionOrderWizardService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ProductionOrderService productionOrderService;
    protected BillOfMaterialRepository billOfMaterialRepo;
    protected ProductRepository productRepo;
    protected AppProductionService appProductionService;

    @Inject
    public ProductionOrderWizardServiceImpl(ProductionOrderService productionOrderService, BillOfMaterialRepository billOfMaterialRepo, ProductRepository productRepo, AppProductionService appProductionService) {
        this.productionOrderService = productionOrderService;
        this.billOfMaterialRepo = billOfMaterialRepo;
        this.productRepo = productRepo;
        this.appProductionService = appProductionService;
    }

    @Override
    public Long validate(Context context) throws AxelorException {
        Map bomContext = (Map)context.get((Object)"billOfMaterial");
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)this.billOfMaterialRepo.find(((Integer)bomContext.get("id")).longValue()));
        BigDecimal qty = new BigDecimal((String)context.get((Object)"qty"));
        Product product = null;
        if (context.get((Object)"product") != null) {
            Map productContext = (Map)context.get((Object)"product");
            product = (Product)((Object)this.productRepo.find(((Integer)productContext.get("id")).longValue()));
        } else {
            product = billOfMaterial.getProduct();
        }
        ZonedDateTime startDateT = context.containsKey((Object)"_startDate") && context.get((Object)"_startDate") != null ? ZonedDateTime.parse((CharSequence)context.get((Object)"_startDate"), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault())) : this.appProductionService.getTodayDateTime();
        ProductionOrder productionOrder = this.productionOrderService.generateProductionOrder(product, billOfMaterial, qty, startDateT.toLocalDateTime());
        if (productionOrder != null) {
            return productionOrder.getId();
        }
        throw new AxelorException(4, I18n.get((String)"Error during production's order's creation"));
    }
}

