/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.app.AppSettings;
import com.axelor.apps.ReportFactory;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class CostSheetController {
    public void printCostSheetLineDetail(ActionRequest request, ActionResponse response) {
        try {
            CostSheet costSheet = (CostSheet)((Object)request.getContext().asType(CostSheet.class));
            Long costSheetId = costSheet.getId();
            String name = I18n.get((String)"Cost sheet");
            String fileLink = ReportFactory.createReport((String)"CostSheet.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", (Object)this.getTimezone(costSheet)).addParam("CostSheetId", (Object)costSheetId).addParam("manageCostSheetGroup", (Object)((AppProductionService)Beans.get(AppProductionService.class)).getAppProduction().getManageCostSheetGroup()).addParam("BaseUrl", (Object)AppSettings.get().getBaseURL()).generate().getFileLink();
            response.setCanClose(true);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private String getTimezone(CostSheet costSheet) {
        if (costSheet.getManufOrder() == null || costSheet.getManufOrder().getCompany() == null) {
            return null;
        }
        return costSheet.getManufOrder().getCompany().getTimezone();
    }
}

