/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.db.repo.ProdProcessRepository;
import com.axelor.apps.production.service.ProdProcessService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class ProdProcessController {
    public void validateProdProcess(ActionRequest request, ActionResponse response) {
        ProdProcess prodProcess = (ProdProcess)((Object)request.getContext().asType(ProdProcess.class));
        if (prodProcess.getIsConsProOnOperation().booleanValue()) {
            BillOfMaterial bom = null;
            bom = request.getContext().getParent() != null && request.getContext().getParent().getContextClass().getName().equals(BillOfMaterial.class.getName()) ? (BillOfMaterial)((Object)request.getContext().getParent().asType(BillOfMaterial.class)) : (BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).all().filter("self.prodProcess.id = ?1", new Object[]{prodProcess.getId()}).fetchOne());
            if (bom != null) {
                try {
                    ((ProdProcessService)Beans.get(ProdProcessService.class)).validateProdProcess(prodProcess, bom);
                }
                catch (AxelorException e) {
                    TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
                }
            }
        }
    }

    public void changeProdProcessListOutsourcing(ActionRequest request, ActionResponse response) throws AxelorException {
        ProdProcess prodProcess = (ProdProcess)((Object)request.getContext().asType(ProdProcess.class));
        if (prodProcess.getProdProcessLineList() != null) {
            ((ProdProcessService)Beans.get(ProdProcessService.class)).changeProdProcessListOutsourcing(prodProcess);
        }
        response.setValue("prodProcessLineList", prodProcess.getProdProcessLineList());
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        ProdProcess prodProcess = (ProdProcess)((Object)request.getContext().asType(ProdProcess.class));
        String prodProcessId = prodProcess.getId().toString();
        String prodProcessLabel = prodProcess.getName().toString();
        String fileLink = ReportFactory.createReport((String)"ProdProcess.rptdesign", (String)(prodProcessLabel + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", prodProcess.getCompany() != null ? prodProcess.getCompany().getTimezone() : null).addParam("ProdProcessId", (Object)prodProcessId).generate().getFileLink();
        response.setView(ActionView.define((String)prodProcessLabel).add("html", fileLink).map());
    }

    public void checkOriginalProductionProcess(ActionRequest request, ActionResponse response) {
        String message;
        ProdProcessRepository prodProcessRepository = (ProdProcessRepository)((Object)Beans.get(ProdProcessRepository.class));
        ProdProcess prodProcess = (ProdProcess)((Object)prodProcessRepository.find(((ProdProcess)((Object)request.getContext().asType(ProdProcess.class))).getId()));
        List prodProcessSet = Lists.newArrayList();
        prodProcessSet = prodProcessRepository.all().filter("self.originalProdProcess = :origin").bind("origin", (Object)prodProcess).fetch();
        if (!prodProcessSet.isEmpty()) {
            String existingVersions = "";
            for (ProdProcess prodProcessVersion : prodProcessSet) {
                existingVersions = existingVersions + "<li>" + prodProcessVersion.getFullName() + "</li>";
            }
            message = String.format(I18n.get((String)"This production process already has the following versions : <br/><ul> %s </ul>And these versions may also have ones. Do you still wish to create a new one ?"), existingVersions);
        } else {
            message = I18n.get((String)"Do you really wish to create a new version of this production process ?");
        }
        response.setAlert(message);
    }

    public void generateNewVersion(ActionRequest request, ActionResponse response) {
        ProdProcess prodProcess = (ProdProcess)((Object)((ProdProcessRepository)((Object)Beans.get(ProdProcessRepository.class))).find(((ProdProcess)((Object)request.getContext().asType(ProdProcess.class))).getId()));
        ProdProcess copy = ((ProdProcessService)Beans.get(ProdProcessService.class)).generateNewVersion(prodProcess);
        response.setView(ActionView.define((String)"Production process").model(ProdProcess.class.getName()).add("form", "prod-process-form").add("grid", "prod-process-grid").param("search-filters", "prod-process-filters").context("_showRecord", (Object)String.valueOf(copy.getId())).map());
    }
}

