/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.production.db.ProductionBatch;
import com.axelor.apps.production.db.repo.ProductionBatchRepository;
import com.axelor.apps.production.service.batch.ProductionBatchService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProductionBatchController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void computeValuation(ActionRequest request, ActionResponse response) {
        ProductionBatch productionBatch = (ProductionBatch)((Object)request.getContext().asType(ProductionBatch.class));
        productionBatch = (ProductionBatch)((Object)((ProductionBatchRepository)((Object)Beans.get(ProductionBatchRepository.class))).find(productionBatch.getId()));
        Batch batch = ((ProductionBatchService)((Object)Beans.get(ProductionBatchService.class))).computeValuation(productionBatch);
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void showValuation(ActionRequest request, ActionResponse response) throws AxelorException {
        ProductionBatch productionBatch = (ProductionBatch)((Object)request.getContext().asType(ProductionBatch.class));
        productionBatch = (ProductionBatch)((Object)((ProductionBatchRepository)((Object)Beans.get(ProductionBatchRepository.class))).find(productionBatch.getId()));
        String name = I18n.get((String)"Work in progress valuation");
        String fileLink = ReportFactory.createReport((String)"WorkInProgressValuation.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", productionBatch.getCompany() != null ? productionBatch.getCompany().getTimezone() : null).addParam("companyId", (Object)(productionBatch.getCompany() != null ? productionBatch.getCompany().getId() : 0L)).addParam("locationId", (Object)(productionBatch.getWorkshopStockLocation() != null ? productionBatch.getWorkshopStockLocation().getId() : 0L)).addParam("editionDate", (Object)DateTimeFormatter.ofPattern("MMM d, yyyy, hh:mm a").format(productionBatch.getUpdatedOn())).generate().getFileLink();
        LOG.debug("Printing {}", (Object)name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }
}

