/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.supplychain.service.ProjectedStockService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import java.util.Map;

public class ProductionProjectedStockController {
    public static final String VIEW_BUILDING_QTY_TITLE = "%s building";
    public static final String VIEW_MISSING_QTY_TITLE = "%s missing";
    public static final String VIEW_CONSUME_QTY_TITLE = "%s consume";

    public void showBuildingQuantityOfProduct(ActionRequest request, ActionResponse response) {
        Map mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || (Long)mapId.get("productId") == 0L) {
            return;
        }
        Long productId = (Long)mapId.get("productId");
        Long companyId = (Long)mapId.get("companyId");
        Long stockLocationId = (Long)mapId.get("stockLocationId");
        String domain = ((ManufOrderService)Beans.get(ManufOrderService.class)).getBuildingQtyForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find((Long)mapId.get("productId")));
        String title = I18n.get((String)VIEW_BUILDING_QTY_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(StockMoveLine.class.getName()).add("grid", "stock-move-line-produced-manuf-order-grid").add("form", "stock-move-line-form").domain(domain).param("popup", "true").param("popup-save", "false").map());
    }

    public void showConsumeQuantityOfProduct(ActionRequest request, ActionResponse response) {
        Map mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || (Long)mapId.get("productId") == 0L) {
            return;
        }
        Long productId = (Long)mapId.get("productId");
        Long companyId = (Long)mapId.get("companyId");
        Long stockLocationId = (Long)mapId.get("stockLocationId");
        String domain = ((ManufOrderService)Beans.get(ManufOrderService.class)).getConsumeAndMissingQtyForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find((Long)mapId.get("productId")));
        String title = I18n.get((String)VIEW_CONSUME_QTY_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(StockMoveLine.class.getName()).add("grid", "stock-move-line-consumed-manuf-order-grid").add("form", "stock-move-line-form").domain(domain).param("popup", "true").param("popup-save", "false").map());
    }

    public void showMissingQuantityOfProduct(ActionRequest request, ActionResponse response) {
        Map mapId = ((ProjectedStockService)Beans.get(ProjectedStockService.class)).getProductIdCompanyIdStockLocationIdFromContext(request.getContext());
        if (mapId == null || (Long)mapId.get("productId") == 0L) {
            return;
        }
        Long productId = (Long)mapId.get("productId");
        Long companyId = (Long)mapId.get("companyId");
        Long stockLocationId = (Long)mapId.get("stockLocationId");
        String domain = ((ManufOrderService)Beans.get(ManufOrderService.class)).getConsumeAndMissingQtyForAProduct(productId, companyId, stockLocationId);
        Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find((Long)mapId.get("productId")));
        String title = I18n.get((String)VIEW_MISSING_QTY_TITLE);
        title = String.format(title, product.getName());
        response.setView(ActionView.define((String)title).model(StockMoveLine.class.getName()).add("grid", "stock-move-line-consumed-manuf-order-grid").add("form", "stock-move-line-form").domain(domain).param("popup", "true").param("popup-save", "false").map());
    }
}

