/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import java.util.Optional;

public class StockMoveLineController {
    public void compute(ActionRequest request, ActionResponse response) throws AxelorException {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        Optional<Object> stockMove = Optional.ofNullable(stockMoveLine.getStockMove());
        if (!stockMove.isPresent()) {
            Context parentContext = request.getContext().getParent();
            if (parentContext.getContextClass().equals(StockMove.class)) {
                stockMove = Optional.ofNullable(parentContext.asType(StockMove.class));
            } else if (parentContext.getContextClass().equals(ManufOrder.class)) {
                ManufOrder manufOrder = (ManufOrder)((Object)parentContext.asType(ManufOrder.class));
                ManufOrderStockMoveService manufOrderStockMoveService = (ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class);
                stockMove = manufOrderStockMoveService.getPlannedStockMove(manufOrder.getInStockMoveList());
            }
            if (!stockMove.isPresent()) {
                return;
            }
        }
        stockMoveLine = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).compute(stockMoveLine, stockMove.get());
        response.setValue("companyPurchasePrice", (Object)stockMoveLine.getCompanyPurchasePrice());
        response.setValue("unitPriceUntaxed", (Object)stockMoveLine.getUnitPriceUntaxed());
        response.setValue("unitPriceTaxed", (Object)stockMoveLine.getUnitPriceTaxed());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProductInfo(ActionRequest request, ActionResponse response) {
        try {
            Company company;
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            StockMove stockMove = stockMoveLine.getStockMove();
            if (stockMove == null) {
                Context parentContext = request.getContext().getParent();
                if (parentContext.getContextClass().equals(StockMove.class)) {
                    stockMove = (StockMove)((Object)parentContext.asType(StockMove.class));
                    company = stockMove.getCompany();
                } else if (parentContext.getContextClass().equals(ManufOrder.class)) {
                    ManufOrder manufOrder = (ManufOrder)((Object)parentContext.asType(ManufOrder.class));
                    company = manufOrder.getCompany();
                } else {
                    if (!parentContext.getContextClass().equals(OperationOrder.class)) throw new AxelorException(5, "Unknown parent context class.");
                    OperationOrder operationOrder = (OperationOrder)((Object)parentContext.asType(OperationOrder.class));
                    if (operationOrder.getManufOrder() == null) {
                        return;
                    }
                    company = operationOrder.getManufOrder().getCompany();
                }
            } else {
                company = stockMove.getCompany();
            }
            if (stockMoveLine.getProduct() == null) {
                stockMoveLine = new StockMoveLine();
                response.setValues((Object)Mapper.toMap((Object)((Object)stockMoveLine)));
                return;
            }
            ((StockMoveLineService)Beans.get(StockMoveLineService.class)).setProductInfo(stockMove, stockMoveLine, company);
            response.setValues((Object)stockMoveLine);
            return;
        }
        catch (Exception e) {
            StockMoveLine stockMoveLine = new StockMoveLine();
            response.setValues((Object)Mapper.toMap((Object)((Object)stockMoveLine)));
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

