/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.apps.production.db.repo.UnitCostCalculationRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.UnitCostCalculationService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;

@Singleton
public class UnitCostCalculationController {
    public void runUnitCostCalc(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            UnitCostCalculation unitCostCalculation = (UnitCostCalculation)((Object)request.getContext().asType(UnitCostCalculation.class));
            unitCostCalculation = (UnitCostCalculation)((Object)((UnitCostCalculationRepository)((Object)Beans.get(UnitCostCalculationRepository.class))).find(unitCostCalculation.getId()));
            ((UnitCostCalculationService)Beans.get(UnitCostCalculationService.class)).runUnitCostCalc(unitCostCalculation);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateUnitCosts(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            UnitCostCalculation unitCostCalculation = (UnitCostCalculation)((Object)request.getContext().asType(UnitCostCalculation.class));
            unitCostCalculation = (UnitCostCalculation)((Object)((UnitCostCalculationRepository)((Object)Beans.get(UnitCostCalculationRepository.class))).find(unitCostCalculation.getId()));
            ((UnitCostCalculationService)Beans.get(UnitCostCalculationService.class)).updateUnitCosts(unitCostCalculation);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void exportUnitCostCalc(ActionRequest request, ActionResponse response) throws IOException {
        try {
            UnitCostCalculation unitCostCalculation = (UnitCostCalculation)((Object)request.getContext().asType(UnitCostCalculation.class));
            unitCostCalculation = (UnitCostCalculation)((Object)((UnitCostCalculationRepository)((Object)Beans.get(UnitCostCalculationRepository.class))).find(unitCostCalculation.getId()));
            String fileName = unitCostCalculation.getUnitCostCalcSeq() + "-" + ((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")) + ".csv";
            MetaFile metaFile = ((UnitCostCalculationService)Beans.get(UnitCostCalculationService.class)).exportUnitCostCalc(unitCostCalculation, fileName);
            response.setView(ActionView.define((String)fileName).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + metaFile.getId() + "/content/download?v=" + metaFile.getVersion()).map());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void importUnitCostCalc(ActionRequest request, ActionResponse response) throws IOException {
        try {
            LinkedHashMap map = (LinkedHashMap)request.getContext().get((Object)"metaFile");
            MetaFile dataFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).find(Long.valueOf(((Integer)map.get("id")).longValue()));
            File csvFile = MetaFiles.getPath((MetaFile)dataFile).toFile();
            Long unitCostCalculationId = Long.valueOf(request.getContext().get((Object)"_id").toString());
            UnitCostCalculation unitCostCalculation = (UnitCostCalculation)((Object)((UnitCostCalculationRepository)((Object)Beans.get(UnitCostCalculationRepository.class))).find(unitCostCalculationId));
            if (Files.getFileExtension((String)csvFile.getName()).equals("csv")) {
                ((UnitCostCalculationService)Beans.get(UnitCostCalculationService.class)).importUnitCostCalc(dataFile, unitCostCalculation);
                response.setCanClose(true);
            } else {
                response.setError("Uploaded file is not a CSV file");
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

