/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SALE_ADVANCE_PAYMENT", indexes={@Index(columnList="sale_order"), @Index(columnList="currency")})
@Track(fields={@TrackField(name="amount", on={TrackEvent.UPDATE}), @TrackField(name="advancePaymentDate", on={TrackEvent.UPDATE}), @TrackField(name="saleOrder", on={TrackEvent.UPDATE}), @TrackField(name="currency", on={TrackEvent.UPDATE}), @TrackField(name="statusSelect", on={TrackEvent.UPDATE})})
public class AdvancePayment
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_ADVANCE_PAYMENT_SEQ")
    @SequenceGenerator(name="SALE_ADVANCE_PAYMENT_SEQ", sequenceName="SALE_ADVANCE_PAYMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Amount")
    @NotNull
    private BigDecimal amount = new BigDecimal("0");
    @Widget(title="Date")
    @NotNull
    private LocalDate advancePaymentDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Status", selection="advance.payment.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getAdvancePaymentDate() {
        return this.advancePaymentDate;
    }

    public void setAdvancePaymentDate(LocalDate advancePaymentDate) {
        this.advancePaymentDate = advancePaymentDate;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancePayment)) {
            return false;
        }
        AdvancePayment other = (AdvancePayment)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("amount", (Object)this.getAmount()).add("advancePaymentDate", (Object)this.getAdvancePaymentDate()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

